package com.vaadin.uitest.model.chat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ChatCompletionMessage implements Serializable {

    public enum Role {
        SYSTEM("system"), USER("user"), ASSISTANT("assistant");

        private final String role;

        Role(String role) {
            this.role = role;
        }

        @Override
        @JsonValue
        public String toString() {
            return role;
        }

        @JsonCreator
        public static Role fromString(String value) {
            return Role.valueOf(value.toUpperCase());
        }
    }

    private Role role;
    private String content;
    private int index;
    private float score;
    private List<Link> links = new ArrayList<>();

    public ChatCompletionMessage() {
    }

    public ChatCompletionMessage(Role role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatCompletionMessage(Role role, String content, List<Link> links,
            int index, float score) {
        this.role = role;
        this.content = content;
        this.links = links;
        this.index = index;
        this.score = score;
    }

    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<Link> getLinks() {
        return links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void addLink(Link link) {
        links.add(link);
    }

    public void addLinks(Collection<Link> links) {
        this.links.addAll(links);
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public float getScore() {
        return score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    @Override
    public String toString() {
        return "\n ChatCompletionMessage [role: " + role + ", index: " + index
                + ", score: " + score + ",\n  links: " + links
                + ",\n  content: \n    size:" + content.length()
                + " Bytes\n    summary: " + content.substring(0, 100)
                + " ... ]";
    }

}
