package com.vaadin.uitest.ai.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ParallelRunner {

    public <T, R> Map<T, R> execute(List<T> prompts, Function<T, R> service,
            int maxJobs) throws InterruptedException, ExecutionException {

        Map<T, R> resultMap = new HashMap<>();
        if (prompts.size() == 1) {
            resultMap.put(prompts.get(0), service.apply(prompts.get(0)));
            return resultMap;
        }

        ExecutorService executorService = Executors.newFixedThreadPool(maxJobs);

        List<CompletableFuture<Void>> futures = prompts.stream()
                .map(argument -> CompletableFuture
                        .supplyAsync(() -> service.apply(argument),
                                executorService)
                        .thenAccept(result -> resultMap.put(argument, result)))
                .collect(Collectors.toList());

        CompletableFuture<Void> allFutures = CompletableFuture
                .allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allFutures.get();
        } finally {
            executorService.shutdown();
        }
        return resultMap;
    }
}
