package com.vaadin.uitest.ai.services;

import static com.vaadin.uitest.ai.services.AiServiceConstants.MODEL;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.services.assistant.AssistantService;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import com.vaadin.uitest.model.chat.ChatCompletionMessage.Role;

public class AiAssistantParserService implements LLMService {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(AiAssistantParserService.class);

    private final AssistantService assistantService;

    public AiAssistantParserService() {
        LOGGER.info("Using the {} model", getModel());
        this.assistantService = new AssistantService();
    }

    public String getJavaHtmlTemplate(Object... args) {
        return String.format(prompts().get(PARSER_ASSISTANT_QUESTION), args[0],
                args[0],
                PromptUtils.cleanSourceCode((String) args[1],
                        (Framework) args[0]),
                PromptUtils.cleanHtml((String) args[2]));
    }

    @Override
    public String getPromptTemplate(AiArguments aiArguments) {
        return getJavaHtmlTemplate(aiArguments.getFramework(),
                aiArguments.getSource(), aiArguments.getHtml());
    }

    @Override
    public String requestAI(AiArguments aiArguments) {
        List<ChatCompletionMessage> history = new ArrayList<>();
        history.add(new ChatCompletionMessage(Role.SYSTEM,
                getChatAssistantSystemMessage("Bart",
                        aiArguments.getFramework())));
        history.add(
                new ChatCompletionMessage(Role.USER, aiArguments.getPrompt()));
        return assistantService.getCompletionString(history);
    }

    @Override
    public String getModel() {
        return MODEL;
    }
}
