/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.starter;

import com.vaadin.flow.spring.SpringSecurityAutoConfiguration;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategyConfiguration;
import com.vaadin.flow.spring.security.VaadinSecurityConfigurer;
import com.vaadin.sso.core.BackChannelLogoutFilter;
import com.vaadin.sso.starter.SingleSignOnProperties;
import com.vaadin.sso.starter.UidlExpiredSessionStrategy;
import com.vaadin.sso.starter.UidlRedirectStrategy;
import jakarta.servlet.Filter;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.oauth2.client.autoconfigure.ConditionalOnOAuth2ClientRegistrationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@AutoConfigureBefore(value={SpringSecurityAutoConfiguration.class})
@EnableWebSecurity
@ConditionalOnOAuth2ClientRegistrationProperties
@EnableConfigurationProperties(value={SingleSignOnProperties.class})
@Import(value={VaadinAwareSecurityContextHolderStrategyConfiguration.class})
public class SingleSignOnConfiguration {
    private final SingleSignOnProperties properties;
    private final OidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler;
    private final SessionRegistry sessionRegistry;
    private final BackChannelLogoutFilter backChannelLogoutFilter;

    public SingleSignOnConfiguration(SingleSignOnProperties properties, SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher) {
        this.properties = properties;
        this.sessionRegistry = sessionRegistry;
        this.logoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        this.logoutSuccessHandler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        this.backChannelLogoutFilter = new BackChannelLogoutFilter(sessionRegistry, clientRegistrationRepository, eventPublisher);
    }

    @Bean
    public SecurityFilterChain vaadinSecurityFilterChain(HttpSecurity http) throws Exception {
        String loginRoute = Objects.requireNonNullElse(this.properties.getLoginRoute(), "/login");
        String logoutRedirectRoute = Objects.requireNonNullElse(this.properties.getLogoutRedirectRoute(), "{baseUrl}");
        String backChannelLogoutRoute = Objects.requireNonNullElse(this.properties.getBackChannelLogoutRoute(), "/logout/back-channel/{registrationId}");
        int maximumSessions = this.properties.getMaximumConcurrentSessions();
        this.logoutSuccessHandler.setPostLogoutRedirectUri(logoutRedirectRoute);
        http.with((SecurityConfigurerAdapter)VaadinSecurityConfigurer.vaadin(), vaadin -> vaadin.oauth2LoginPage(loginRoute, logoutRedirectRoute).logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler).enableExceptionHandlingConfiguration(false));
        http.exceptionHandling(exceptionHandling -> {
            LoginUrlAuthenticationEntryPoint entryPoint = new LoginUrlAuthenticationEntryPoint(loginRoute);
            exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)entryPoint);
        }).sessionManagement(sessionManagement -> sessionManagement.sessionConcurrency(concurrency -> {
            concurrency.maximumSessions(maximumSessions);
            concurrency.sessionRegistry(this.sessionRegistry);
            UidlExpiredSessionStrategy expiredStrategy = new UidlExpiredSessionStrategy();
            concurrency.expiredSessionStrategy((SessionInformationExpiredStrategy)expiredStrategy);
        }));
        if (this.properties.isBackChannelLogout()) {
            this.backChannelLogoutFilter.setBackChannelLogoutRoute(backChannelLogoutRoute);
            http.addFilterAfter((Filter)this.backChannelLogoutFilter, LogoutFilter.class);
            RequestMatcher matcher = this.backChannelLogoutFilter.getRequestMatcher();
            http.csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{matcher}));
        } else {
            http.oidcLogout().backChannel(Customizer.withDefaults());
        }
        return (SecurityFilterChain)http.build();
    }
}

