/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.starter;

import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.VaadinWebSecurity;
import com.vaadin.sso.core.BackChannelLogoutFilter;
import com.vaadin.sso.starter.SingleSignOnProperties;
import com.vaadin.sso.starter.UidlExpiredSessionStrategy;
import com.vaadin.sso.starter.UidlRedirectStrategy;
import jakarta.servlet.Filter;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@EnableWebSecurity
@Conditional(value={ClientsConfiguredCondition.class})
@ConditionalOnProperty(name={"auto-configure"}, prefix="vaadin.sso", matchIfMissing=true)
@EnableConfigurationProperties(value={SingleSignOnProperties.class})
public class SingleSignOnConfiguration
extends VaadinWebSecurity {
    private final SingleSignOnProperties properties;
    private final OidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler;
    private final VaadinSavedRequestAwareAuthenticationSuccessHandler loginSuccessHandler;
    private final SessionRegistry sessionRegistry;
    private final BackChannelLogoutFilter backChannelLogoutFilter;

    public SingleSignOnConfiguration(SingleSignOnProperties properties, SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher) {
        this.properties = properties;
        this.sessionRegistry = sessionRegistry;
        this.loginSuccessHandler = new VaadinSavedRequestAwareAuthenticationSuccessHandler();
        this.logoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        this.logoutSuccessHandler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        this.backChannelLogoutFilter = new BackChannelLogoutFilter(sessionRegistry, clientRegistrationRepository, eventPublisher);
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        String loginRoute = Objects.requireNonNullElse(this.properties.getLoginRoute(), "/login");
        String logoutRedirectRoute = Objects.requireNonNullElse(this.properties.getLogoutRedirectRoute(), "{baseUrl}");
        String backChannelLogoutRoute = Objects.requireNonNullElse(this.properties.getBackChannelLogoutRoute(), "/logout/back-channel/{registrationId}");
        int maximumSessions = this.properties.getMaximumConcurrentSessions();
        http.oauth2Login(oauth2Login -> {
            RequestCache requestCache = (RequestCache)http.getSharedObject(RequestCache.class);
            if (requestCache != null) {
                this.loginSuccessHandler.setRequestCache(requestCache);
            }
            oauth2Login.successHandler((AuthenticationSuccessHandler)this.loginSuccessHandler);
            oauth2Login.loginPage(loginRoute).permitAll();
            this.getViewAccessChecker().setLoginView(loginRoute);
        }).logout(logout -> {
            this.logoutSuccessHandler.setPostLogoutRedirectUri(logoutRedirectRoute);
            logout.logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler);
        }).exceptionHandling(exceptionHandling -> {
            LoginUrlAuthenticationEntryPoint entryPoint = new LoginUrlAuthenticationEntryPoint(loginRoute);
            exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)entryPoint);
        }).sessionManagement(sessionManagement -> sessionManagement.sessionConcurrency(concurrency -> {
            concurrency.maximumSessions(maximumSessions);
            concurrency.sessionRegistry(this.sessionRegistry);
            UidlExpiredSessionStrategy expiredStrategy = new UidlExpiredSessionStrategy();
            concurrency.expiredSessionStrategy((SessionInformationExpiredStrategy)expiredStrategy);
        }));
        if (this.properties.isBackChannelLogout()) {
            this.backChannelLogoutFilter.setBackChannelLogoutRoute(backChannelLogoutRoute);
            http.addFilterAfter((Filter)this.backChannelLogoutFilter, LogoutFilter.class);
            RequestMatcher matcher = this.backChannelLogoutFilter.getRequestMatcher();
            http.csrf().ignoringRequestMatchers(new RequestMatcher[]{matcher});
        }
    }
}

