/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.starter;

import com.vaadin.flow.server.HandlerHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.session.SessionInformationExpiredEvent;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;

public class UidlExpiredSessionStrategy
implements SessionInformationExpiredStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidlExpiredSessionStrategy.class);

    public void onExpiredSessionDetected(SessionInformationExpiredEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getRequest();
        HttpServletResponse response = event.getResponse();
        String redirectRoute = "/" + request.getContextPath();
        String servletMapping = request.getHttpServletMapping().getPattern();
        if (HandlerHelper.isFrameworkInternalRequest((String)servletMapping, (HttpServletRequest)request)) {
            LOGGER.debug("Session expired during internal request: writing a Vaadin-Refresh token to the response body");
            response.getWriter().write("Vaadin-Refresh: " + redirectRoute);
        } else {
            LOGGER.debug("Session expired: redirecting to " + redirectRoute);
            response.setStatus(302);
            response.setHeader("Location", redirectRoute);
        }
    }
}

