/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.starter;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class LicenseCheckerServiceInitListener
implements VaadinServiceInitListener {
    static final String PROPERTIES_RESOURCE = "sso-kit.properties";
    static final String VERSION_PROPERTY = "sso-kit.version";
    static final String PRODUCT_NAME = "vaadin-sso-kit";

    public void serviceInit(ServiceInitEvent event) {
        VaadinService service = event.getSource();
        try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties((String)PROPERTIES_RESOURCE);
            String version = properties.getProperty(VERSION_PROPERTY);
            UsageStatistics.markAsUsed((String)PRODUCT_NAME, (String)version);
            if (!service.getDeploymentConfiguration().isProductionMode()) {
                BuildType buildType = null;
                LicenseChecker.checkLicense((String)PRODUCT_NAME, (String)version, buildType);
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

