/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.sso.starter;

import com.vaadin.flow.spring.SpringSecurityAutoConfiguration;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategyConfiguration;
import com.vaadin.flow.spring.security.VaadinSecurityConfigurer;
import com.vaadin.hilla.sso.starter.BackChannelLogoutSubscription;
import com.vaadin.hilla.sso.starter.BootstrapDataServiceListener;
import com.vaadin.hilla.sso.starter.SingleSignOnContext;
import com.vaadin.hilla.sso.starter.SingleSignOnProperties;
import com.vaadin.hilla.sso.starter.endpoint.BackChannelLogoutEndpoint;
import com.vaadin.hilla.sso.starter.endpoint.SingleSignOnEndpoint;
import com.vaadin.hilla.sso.starter.endpoint.UserEndpoint;
import com.vaadin.sso.core.BackChannelLogoutFilter;
import jakarta.servlet.Filter;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.oauth2.client.autoconfigure.ConditionalOnOAuth2ClientRegistrationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@AutoConfigureBefore(value={SpringSecurityAutoConfiguration.class})
@EnableWebSecurity
@ConditionalOnOAuth2ClientRegistrationProperties
@EnableConfigurationProperties(value={SingleSignOnProperties.class})
@Import(value={VaadinAwareSecurityContextHolderStrategyConfiguration.class})
public class SingleSignOnConfiguration {
    private final SingleSignOnProperties properties;
    private final BackChannelLogoutFilter backChannelLogoutFilter;
    private final SessionRegistry sessionRegistry;
    private final BackChannelLogoutSubscription backChannelLogoutSubscription;
    private final SingleSignOnContext singleSignOnContext;
    private final BootstrapDataServiceListener bootstrapDataServiceListener;
    private final BackChannelLogoutEndpoint backChannelLogoutEndpoint;
    private final SingleSignOnEndpoint singleSignOnEndpoint;
    private final UserEndpoint userEndpoint;

    public SingleSignOnConfiguration(SingleSignOnProperties properties, SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher) {
        this.properties = properties;
        this.sessionRegistry = sessionRegistry;
        this.backChannelLogoutFilter = new BackChannelLogoutFilter(sessionRegistry, clientRegistrationRepository, eventPublisher);
        this.backChannelLogoutSubscription = new BackChannelLogoutSubscription();
        this.singleSignOnContext = new SingleSignOnContext(clientRegistrationRepository, properties, this.backChannelLogoutSubscription);
        this.bootstrapDataServiceListener = new BootstrapDataServiceListener(this.singleSignOnContext);
        this.backChannelLogoutEndpoint = new BackChannelLogoutEndpoint(this.singleSignOnContext);
        this.singleSignOnEndpoint = new SingleSignOnEndpoint(this.singleSignOnContext);
        this.userEndpoint = new UserEndpoint();
    }

    @Bean
    public BackChannelLogoutSubscription backChannelLogoutSubscription() {
        return this.backChannelLogoutSubscription;
    }

    @Bean
    public SingleSignOnContext singleSignOnContext() {
        return this.singleSignOnContext;
    }

    @Bean
    public BootstrapDataServiceListener bootstrapDataServiceListener() {
        return this.bootstrapDataServiceListener;
    }

    @Bean
    public BackChannelLogoutEndpoint backChannelLogoutEndpoint() {
        return this.backChannelLogoutEndpoint;
    }

    @Bean
    public SingleSignOnEndpoint singleSignOnEndpoint() {
        return this.singleSignOnEndpoint;
    }

    @Bean
    public UserEndpoint userEndpoint() {
        return this.userEndpoint;
    }

    @Bean
    public SecurityFilterChain vaadinSecurityFilterChain(HttpSecurity http) throws Exception {
        String loginRoute = Objects.requireNonNullElse(this.properties.getLoginRoute(), "/login");
        String logoutRedirectRoute = Objects.requireNonNullElse(this.properties.getLogoutRedirectRoute(), "{baseUrl}");
        http.with((SecurityConfigurerAdapter)VaadinSecurityConfigurer.vaadin(), vaadin -> vaadin.oauth2LoginPage(loginRoute, logoutRedirectRoute));
        http.sessionManagement(sessionManagement -> sessionManagement.sessionConcurrency(concurrency -> {
            concurrency.maximumSessions(this.properties.getMaximumConcurrentSessions());
            concurrency.sessionRegistry(this.sessionRegistry);
        }));
        if (this.properties.isBackChannelLogout()) {
            this.backChannelLogoutFilter.setBackChannelLogoutRoute(this.properties.getBackChannelLogoutRoute());
            http.addFilterAfter((Filter)this.backChannelLogoutFilter, LogoutFilter.class);
            RequestMatcher matcher = this.backChannelLogoutFilter.getRequestMatcher();
            http.csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{matcher}));
        } else {
            http.oidcLogout().backChannel(Customizer.withDefaults());
        }
        return (SecurityFilterChain)http.build();
    }
}

