/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.sso.starter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.hilla.sso.starter.SingleSignOnContext;
import com.vaadin.hilla.sso.starter.SingleSignOnData;
import java.io.Serializable;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class BootstrapDataServiceListener
implements VaadinServiceInitListener {
    static final String SCRIPT_STRING = "window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.SingleSignOnData = %s;\n";
    private final SingleSignOnContext singleSignOnContext;
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public BootstrapDataServiceListener(SingleSignOnContext singleSignOnContext) {
        this.singleSignOnContext = singleSignOnContext;
    }

    public void serviceInit(ServiceInitEvent event) {
        event.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)indexHtmlResponse -> {
            SingleSignOnData data = this.singleSignOnContext.getSingleSignOnData();
            String script = SCRIPT_STRING.formatted(this.json(data));
            Element scriptNode = indexHtmlResponse.getDocument().createElement("script").appendChild((Node)new DataNode(script));
            indexHtmlResponse.getDocument().body().appendChild((Node)scriptNode);
        });
    }

    private String json(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException | NullPointerException e) {
            return "undefined";
        }
    }
}

