/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.sso.starter;

import com.vaadin.hilla.Nonnull;
import com.vaadin.hilla.sso.starter.BackChannelLogoutSubscription;
import com.vaadin.hilla.sso.starter.SingleSignOnData;
import com.vaadin.hilla.sso.starter.SingleSignOnProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;

public class SingleSignOnContext {
    private static final String ROLE_PREFIX = "ROLE_";
    private static final int ROLE_PREFIX_LENGTH = "ROLE_".length();
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final SingleSignOnProperties properties;
    private final BackChannelLogoutSubscription backChannelLogoutSubscription;

    public SingleSignOnContext(ClientRegistrationRepository clientRegistrationRepository, SingleSignOnProperties properties, BackChannelLogoutSubscription backChannelLogoutSubscription) {
        Objects.requireNonNull(clientRegistrationRepository);
        Objects.requireNonNull(properties);
        Objects.requireNonNull(backChannelLogoutSubscription);
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.properties = properties;
        this.backChannelLogoutSubscription = backChannelLogoutSubscription;
    }

    public static Optional<OidcUser> getOidcUser() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::getPrincipal).filter(OidcUser.class::isInstance).map(OidcUser.class::cast);
    }

    static Optional<HttpServletRequest> getCurrentHttpRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest);
    }

    public @Nonnull List<@Nonnull String> getRegisteredProviders() {
        return Optional.of(this.clientRegistrationRepository).filter(InMemoryClientRegistrationRepository.class::isInstance).map(InMemoryClientRegistrationRepository.class::cast).map(repo -> {
            ArrayList list = new ArrayList();
            repo.iterator().forEachRemaining(registration -> list.add(registration.getRegistrationId()));
            return list;
        }).orElse(List.of());
    }

    public SingleSignOnData getSingleSignOnData() {
        SingleSignOnData data = new SingleSignOnData();
        data.setLoginLink(this.properties.getLoginRoute());
        SingleSignOnContext.getOidcUser().ifPresent(user -> {
            data.setAuthenticated(true);
            data.setRoles(SingleSignOnContext.userRoles(user));
            data.setLogoutLink(this.getLogoutLink().orElseThrow());
            data.setBackChannelLogoutEnabled(this.isBackChannelLogoutEnabled());
        });
        return data;
    }

    public static List<String> userRoles(OidcUser user) {
        return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).filter(a -> a.startsWith(ROLE_PREFIX)).map(a -> a.substring(ROLE_PREFIX_LENGTH)).toList();
    }

    public boolean isBackChannelLogoutEnabled() {
        return this.properties.isBackChannelLogout();
    }

    public Flux<BackChannelLogoutSubscription.Message> getBackChannelLogoutFlux() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return this.backChannelLogoutSubscription.getFluxForUser(principal);
    }

    public Optional<String> getLogoutLink() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(OAuth2AuthenticationToken.class::isInstance).map(OAuth2AuthenticationToken.class::cast).map(this::buildLogoutLink);
    }

    private String buildLogoutLink(OAuth2AuthenticationToken authenticationToken) {
        String registrationId = authenticationToken.getAuthorizedClientRegistrationId();
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        ClientRegistration.ProviderDetails details = clientRegistration.getProviderDetails();
        String endSessionEndpoint = details.getConfigurationMetadata().get("end_session_endpoint").toString();
        OidcUser user = (OidcUser)authenticationToken.getPrincipal();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endSessionEndpoint).queryParam("id_token_hint", new Object[]{user.getIdToken().getTokenValue()}).queryParam("post_logout_redirect_uri", new Object[]{this.getPostLogoutRedirectUri()});
        return builder.toUriString();
    }

    private String getPostLogoutRedirectUri() {
        String logoutRedirectRoute = this.properties.getLogoutRedirectRoute();
        String logoutUri = logoutRedirectRoute.contains("{baseUrl}") ? SingleSignOnContext.getCurrentHttpRequest().map(request -> UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build().toUriString()).map(uri -> logoutRedirectRoute.replace("{baseUrl}", (CharSequence)uri)).orElse(logoutRedirectRoute) : logoutRedirectRoute;
        return logoutUri;
    }
}

