/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.core;

import java.net.URL;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Deprecated(since="3.1", forRemoval=true)
public final class OidcLogoutTokenValidator
implements OAuth2TokenValidator<Jwt> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogoutTokenValidator.class);
    private static final Duration DEFAULT_CLOCK_SKEW = Duration.ofSeconds(60L);
    private static final String ID_TOKEN_SIGNED_RESPONSE_ALG = "id_token_signed_response_alg";
    private static final String ALG_HEADER = "alg";
    private static final String ALG_RS256 = "RS256";
    private static final String BC_LOGOUT_EVENT = "http://schemas.openid.net/event/backchannel-logout";
    private final ClientRegistration clientRegistration;
    private Duration clockSkew = DEFAULT_CLOCK_SKEW;
    private Clock clock = Clock.systemUTC();

    public OidcLogoutTokenValidator(ClientRegistration clientRegistration) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        this.clientRegistration = clientRegistration;
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Object nonce;
        Map events;
        Instant now;
        Map<String, Object> invalidClaims = OidcLogoutTokenValidator.validateRequiredClaims(token);
        if (!invalidClaims.isEmpty()) {
            LOGGER.warn("Logout token validation failed because of missing claims: {}", invalidClaims);
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{OidcLogoutTokenValidator.invalidLogoutTokenClaims(invalidClaims)});
        }
        ClientRegistration.ProviderDetails providerDetails = this.clientRegistration.getProviderDetails();
        Map configuration = providerDetails.getConfigurationMetadata();
        String alg = (String)token.getHeaders().get(ALG_HEADER);
        if (!Objects.equals(alg, configuration.getOrDefault(ID_TOKEN_SIGNED_RESPONSE_ALG, ALG_RS256))) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{OidcLogoutTokenValidator.invalidLogoutTokenAlgorithm(alg)});
        }
        String iss = providerDetails.getIssuerUri();
        if (!Objects.equals(iss, token.getIssuer().toExternalForm())) {
            invalidClaims.put("iss", token.getIssuer());
        }
        if (!token.getAudience().contains(this.clientRegistration.getClientId())) {
            invalidClaims.put("aud", token.getAudience());
        }
        if ((now = Instant.now(this.clock)).plus(this.clockSkew).isBefore(token.getIssuedAt())) {
            invalidClaims.put("iat", token.getIssuedAt());
        }
        String subject = token.getSubject();
        String sid = token.getClaimAsString("sid");
        if (subject == null && sid == null) {
            invalidClaims.put("sub", subject);
            invalidClaims.put("sid", sid);
        }
        if ((events = token.getClaimAsMap("events")) == null || !events.containsKey(BC_LOGOUT_EVENT)) {
            invalidClaims.put("events", events);
        }
        if ((nonce = token.getClaim("nonce")) != null) {
            invalidClaims.put("nonce", nonce);
        }
        if (!invalidClaims.isEmpty()) {
            LOGGER.warn("Logout token validation failed because of invalid claims: {}", invalidClaims);
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{OidcLogoutTokenValidator.invalidLogoutTokenClaims(invalidClaims)});
        }
        LOGGER.debug("Logout token validation succeeded");
        return OAuth2TokenValidatorResult.success();
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    private static OAuth2Error invalidLogoutTokenAlgorithm(String alg) {
        return new OAuth2Error("invalid_request", "The Logout Token algorithm is invalid: " + alg, "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    private static OAuth2Error invalidLogoutTokenClaims(Map<String, Object> invalidClaims) {
        return new OAuth2Error("invalid_request", "The Logout Token contains invalid claims: " + invalidClaims, "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    private static Map<String, Object> validateRequiredClaims(Jwt token) {
        List audience;
        Instant issuedAt;
        HashMap<String, Object> requiredClaims = new HashMap<String, Object>();
        URL issuer = token.getIssuer();
        if (issuer == null) {
            requiredClaims.put("iss", issuer);
        }
        if ((issuedAt = token.getIssuedAt()) == null) {
            requiredClaims.put("iat", issuedAt);
        }
        if (CollectionUtils.isEmpty((Collection)(audience = token.getAudience()))) {
            requiredClaims.put("aud", audience);
        }
        return requiredClaims;
    }
}

