/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.sso.core;

import com.vaadin.sso.core.OidcLogoutTokenValidator;
import com.vaadin.sso.core.UserLogoutEvent;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class BackChannelLogoutFilter
extends GenericFilterBean {
    static final String TOKEN_PARAM_NAME = "logout_token";
    static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private static final String LOG_MESSAGE = "Did not match request to %s";
    private final SessionRegistry sessionRegistry;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final JwtDecoderFactory<ClientRegistration> decoderFactory;
    private RequestMatcher requestMatcher = new AntPathRequestMatcher("/logout/back-channel/{registrationId}");
    private final ApplicationEventPublisher eventPublisher;

    public BackChannelLogoutFilter(SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher) {
        this(sessionRegistry, clientRegistrationRepository, eventPublisher, (JwtDecoderFactory<ClientRegistration>)((JwtDecoderFactory)clientRegistration -> {
            String issuerUri = clientRegistration.getProviderDetails().getIssuerUri();
            return JwtDecoders.fromOidcIssuerLocation((String)issuerUri);
        }));
    }

    BackChannelLogoutFilter(SessionRegistry sessionRegistry, ClientRegistrationRepository clientRegistrationRepository, ApplicationEventPublisher eventPublisher, JwtDecoderFactory<ClientRegistration> decoderFactory) {
        this.sessionRegistry = Objects.requireNonNull(sessionRegistry);
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.decoderFactory = Objects.requireNonNull(decoderFactory);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresLogout(httpRequest)) {
            this.logger.debug((Object)"Matching Back-Channel logout request");
            this.performLogout(httpRequest, httpResponse);
        }
        chain.doFilter(request, response);
    }

    private void performLogout(HttpServletRequest request, HttpServletResponse response) throws JwtValidationException {
        String clientRegistrationId = (String)this.requestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        if (clientRegistrationId == null) {
            this.logger.warn((Object)"Back-Channel logout request matcher missing required registrationId URI variable:registrationId");
            response.setStatus(400);
            return;
        }
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (clientRegistration == null) {
            this.logger.warn((Object)("Client registration not found: " + clientRegistrationId));
            response.setStatus(400);
            return;
        }
        String token = request.getParameter(TOKEN_PARAM_NAME);
        if (token == null) {
            this.logger.warn((Object)"Back-Channel logout request missing parameter: logout_token");
            response.setStatus(400);
            return;
        }
        OidcLogoutTokenValidator tokenValidator = new OidcLogoutTokenValidator(clientRegistration);
        JwtDecoder decoder = this.decoderFactory.createDecoder((Object)clientRegistration);
        Jwt jwt = decoder.decode(token);
        if (tokenValidator.validate(jwt).hasErrors()) {
            this.logger.warn((Object)"Invalid logout token");
            response.setStatus(400);
            return;
        }
        String tokenSub = jwt.getSubject();
        String tokenSid = jwt.getClaimAsString("sid");
        this.sessionRegistry.getAllPrincipals().stream().filter(principal -> {
            if (principal instanceof OidcUser) {
                OidcUser user = (OidcUser)principal;
                if (tokenSid != null) {
                    String userSid = user.getClaimAsString("sid");
                    return Objects.equals(tokenSid, userSid);
                }
                String userSub = user.getSubject();
                return Objects.equals(tokenSub, userSub);
            }
            return false;
        }).peek(p -> this.eventPublisher.publishEvent((ApplicationEvent)new UserLogoutEvent(p))).flatMap(p -> this.sessionRegistry.getAllSessions(p, false).stream()).forEach(SessionInformation::expireNow);
        response.setStatus(200);
    }

    private boolean requiresLogout(HttpServletRequest request) {
        if (this.requestMatcher.matches(request)) {
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)LogMessage.format((String)LOG_MESSAGE, (Object)this.requestMatcher));
        }
        return false;
    }

    public RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    public void setRequestMatcher(RequestMatcher logoutRequestMatcher) {
        this.requestMatcher = Objects.requireNonNull(logoutRequestMatcher);
    }

    public void setBackChannelLogoutRoute(String backChannelLogoutRoute) {
        Objects.requireNonNull(backChannelLogoutRoute);
        this.setRequestMatcher((RequestMatcher)new AntPathRequestMatcher(backChannelLogoutRoute, "POST"));
    }
}

