/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.shared.impl;

import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.SignalCommand;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class TreeRevision {
    private final Map<Id, Node> nodes;
    private final Map<Id, SignalCommand.ScopeOwnerCommand> originalInserts;
    private final Id ownerId;

    public TreeRevision(Id ownerId, Map<Id, Node> nodes, Map<Id, SignalCommand.ScopeOwnerCommand> originalInserts) {
        this.ownerId = ownerId;
        this.nodes = nodes;
        this.originalInserts = originalInserts;
        assert (this.assertValidTree());
    }

    public Id ownerId() {
        return this.ownerId;
    }

    public Map<Id, Node> nodes() {
        return this.nodes;
    }

    public Map<Id, SignalCommand.ScopeOwnerCommand> originalInserts() {
        return this.originalInserts;
    }

    public Optional<Node.Data> data(Id id) {
        Node node = this.nodes.get(id);
        if (node instanceof Node.Data) {
            Node.Data data = (Node.Data)node;
            return Optional.of(data);
        }
        if (node instanceof Node.Alias) {
            Node.Alias alias = (Node.Alias)node;
            return this.data(alias.target());
        }
        assert (node == null);
        return Optional.empty();
    }

    protected boolean assertValidTree() {
        Node.Data root;
        Node node2;
        HashSet<Id> visited = new HashSet<Id>();
        HashSet<Id> checkedScopeOwners = new HashSet<Id>();
        LinkedList<Id> toCheck = new LinkedList<Id>();
        assert (this.nodes.containsKey(Id.ZERO));
        assert ((node2 = this.nodes.get(Id.ZERO)) instanceof Node.Data && (root = (Node.Data)node2).parent() == null);
        toCheck.add(Id.ZERO);
        if (this.nodes.containsKey(Id.MAX)) {
            assert ((node2 = this.nodes.get(Id.MAX)) instanceof Node.Data && (root = (Node.Data)node2).parent() == null);
            toCheck.add(Id.MAX);
        }
        while (!toCheck.isEmpty()) {
            Id id2 = (Id)toCheck.poll();
            if (!visited.add(id2)) assert (false) : "Already visited";
            Node.Data node3 = this.data(id2).get();
            if (this.ownerId.equals(node3.scopeOwner())) {
                checkedScopeOwners.add(id2);
                SignalCommand.ScopeOwnerCommand scopeOwnerCommand = this.originalInserts.get(id2);
                assert (scopeOwnerCommand != null);
                assert (scopeOwnerCommand.scopeOwner().equals(this.ownerId));
            }
            Stream<Id> allChildren = Stream.concat(node3.listChildren().stream(), node3.mapChildren().values().stream());
            allChildren.forEach(childId -> {
                toCheck.add((Id)childId);
                assert (this.nodes.containsKey(childId));
                Node.Data child = this.data((Id)childId).get();
                assert (child.parent() != null);
                assert (child.parent().equals(id2));
            });
        }
        List<Id> unattached = this.nodes.keySet().stream().filter(id -> this.nodes.get(id) instanceof Node.Data && !visited.contains(id)).toList();
        assert (unattached.isEmpty());
        this.nodes().values().forEach(node -> {
            if (node instanceof Node.Alias) {
                Node.Alias alias = (Node.Alias)node;
                assert (this.nodes.get(alias.target()) instanceof Node.Data);
            }
        });
        assert (checkedScopeOwners.equals(this.originalInserts.keySet()));
        return true;
    }
}

