/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.local;

import com.vaadin.signals.WritableSignal;
import com.vaadin.signals.function.CleanupCallback;
import com.vaadin.signals.function.SignalUpdater;
import com.vaadin.signals.function.ValueModifier;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TransientListener;
import com.vaadin.signals.impl.UsageTracker;
import com.vaadin.signals.operations.CancelableOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class ValueSignal<T>
implements WritableSignal<T> {
    private T value;
    private int version;
    private boolean modifyRunning = false;
    private final List<TransientListener> listeners = new ArrayList<TransientListener>();
    final ReentrantLock lock = new ReentrantLock();

    public ValueSignal(T initialValue) {
        this.value = initialValue;
    }

    public ValueSignal() {
        this(null);
    }

    private void checkPreconditions() {
        assert (this.lock.isHeldByCurrentThread());
        if (Transaction.inTransaction()) {
            throw new IllegalStateException("ValueSignal cannot be used inside signal transactions.");
        }
        if (this.modifyRunning) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public T value() {
        this.lock.lock();
        try {
            this.checkPreconditions();
            if (UsageTracker.isActive()) {
                UsageTracker.registerUsage(this.createUsage(this.version));
            }
            T t = this.value;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UsageTracker.Usage createUsage(final int originalVersion) {
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                ValueSignal.this.lock.lock();
                boolean hasChanges = ValueSignal.this.version != originalVersion;
                ValueSignal.this.lock.unlock();
                return hasChanges;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CleanupCallback onNextChange(TransientListener listener) {
                ValueSignal.this.lock.lock();
                try {
                    boolean keep;
                    if (this.hasChanges() && !(keep = listener.invoke(true))) {
                        CleanupCallback cleanupCallback = () -> {};
                        return cleanupCallback;
                    }
                    ValueSignal.this.listeners.add(listener);
                    CleanupCallback cleanupCallback = () -> {
                        ValueSignal.this.lock.lock();
                        try {
                            ValueSignal.this.listeners.remove(listener);
                        }
                        finally {
                            ValueSignal.this.lock.unlock();
                        }
                    };
                    return cleanupCallback;
                }
                finally {
                    ValueSignal.this.lock.unlock();
                }
            }
        };
    }

    @Override
    public T peek() {
        this.lock.lock();
        try {
            this.checkPreconditions();
            T t = this.value;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setAndNotify(T newValue) {
        assert (this.lock.isHeldByCurrentThread());
        this.value = newValue;
        ++this.version;
        List<TransientListener> copy = List.copyOf(this.listeners);
        this.listeners.clear();
        for (TransientListener listener : copy) {
            boolean keep = listener.invoke(false);
            if (!keep) continue;
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalOperation<T> value(T value) {
        this.lock.lock();
        try {
            this.checkPreconditions();
            T oldValue = this.value;
            this.setAndNotify(value);
            SignalOperation<T> signalOperation = new SignalOperation<T>(new SignalOperation.Result<T>(oldValue));
            return signalOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalOperation<Void> replace(T expectedValue, T newValue) {
        this.lock.lock();
        try {
            this.checkPreconditions();
            if (Objects.equals(expectedValue, this.value)) {
                this.setAndNotify(newValue);
                SignalOperation<Object> signalOperation = new SignalOperation<Object>(new SignalOperation.Result<Object>(null));
                return signalOperation;
            }
            SignalOperation<Void> signalOperation = new SignalOperation<Void>(new SignalOperation.Error("Unexpected value"));
            return signalOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CancelableOperation<T> update(SignalUpdater<T> updater) {
        Objects.requireNonNull(updater);
        this.lock.lock();
        try {
            this.checkPreconditions();
            T oldValue = this.value;
            T newValue = updater.update(oldValue);
            if (newValue != oldValue) {
                this.setAndNotify(newValue);
            }
            CancelableOperation operation = new CancelableOperation();
            operation.result().complete(new SignalOperation.Result<T>(oldValue));
            CancelableOperation cancelableOperation = operation;
            return cancelableOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ValueModifier<T> modifier) {
        Objects.requireNonNull(modifier);
        if (!this.lock.tryLock()) {
            throw new ConcurrentModificationException();
        }
        try {
            this.checkPreconditions();
            this.modifyRunning = true;
        }
        finally {
            this.lock.unlock();
        }
        boolean completed = false;
        try {
            modifier.modify(this.value);
            completed = true;
        }
        finally {
            this.lock.lock();
            try {
                this.modifyRunning = false;
                if (completed) {
                    this.setAndNotify(this.value);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

