/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.shared.impl;

import com.vaadin.signals.Id;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.shared.impl.CommandResult;
import com.vaadin.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.signals.shared.impl.MutableTreeRevision;
import com.vaadin.signals.shared.impl.SignalTree;
import com.vaadin.signals.shared.impl.Snapshot;
import java.util.Map;

public class SynchronousSignalTree
extends SignalTree {
    private Snapshot snapshot = new Snapshot(this.id(), false);

    public SynchronousSignalTree(boolean computedSignal) {
        super(computedSignal ? SignalTree.Type.COMPUTED : SignalTree.Type.SYNCHRONOUS);
    }

    @Override
    public Snapshot confirmed() {
        return this.getWithLock(() -> this.snapshot);
    }

    @Override
    public Snapshot submitted() {
        return this.confirmed();
    }

    @Override
    public SignalTree.PendingCommit prepareCommit(final CommandsAndHandlers changes) {
        assert (this.hasLock());
        final Snapshot oldSnapshot = this.snapshot;
        final MutableTreeRevision builder = new MutableTreeRevision(this.snapshot);
        final Map<Id, CommandResult> results = builder.applyAndGetResults(changes.getCommands());
        final boolean valid = changes.getCommands().stream().map(SignalCommand::commandId).map(results::get).allMatch(CommandResult::accepted);
        return new SignalTree.PendingCommit(){

            @Override
            public boolean canCommit() {
                assert (SynchronousSignalTree.this.hasLock());
                return valid;
            }

            @Override
            public void applyChanges() {
                assert (SynchronousSignalTree.this.hasLock());
                assert (valid);
                SynchronousSignalTree.this.snapshot = new Snapshot(builder);
            }

            @Override
            public void publishChanges() {
                assert (SynchronousSignalTree.this.hasLock());
                assert (valid);
                SynchronousSignalTree.this.notifyObservers(oldSnapshot, SynchronousSignalTree.this.snapshot);
                changes.notifyResultHandlers(results);
                SynchronousSignalTree.this.notifyProcessedCommandSubscribers(changes.getCommands(), results);
            }

            @Override
            public void markAsAborted() {
                Map<Id, CommandResult> rejected = CommandResult.rejectAll(results, "Transaction aborted");
                changes.notifyResultHandlers(rejected);
                SynchronousSignalTree.this.notifyProcessedCommandSubscribers(changes.getCommands(), rejected);
            }
        };
    }
}

