/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.local;

import com.vaadin.signals.Signal;
import com.vaadin.signals.function.CleanupCallback;
import com.vaadin.signals.impl.TransientListener;
import com.vaadin.signals.impl.UsageTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractLocalSignal<T>
implements Signal<T> {
    private final List<TransientListener> listeners = new ArrayList<TransientListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private int version;
    private T signalValue;

    protected AbstractLocalSignal(T initialValue) {
        this.signalValue = initialValue;
    }

    protected void checkPreconditions() {
    }

    @Override
    public T value() {
        this.lock.lock();
        try {
            this.checkPreconditions();
            if (UsageTracker.isActive()) {
                UsageTracker.registerUsage(this.createUsage());
            }
            T t = this.signalValue;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T peek() {
        this.lock.lock();
        try {
            this.checkPreconditions();
            T t = this.signalValue;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    protected boolean tryLock() {
        return this.lock.tryLock();
    }

    protected void assertLockHeld() {
        assert (this.lock.isHeldByCurrentThread());
    }

    protected T getSignalValue() {
        this.assertLockHeld();
        return this.signalValue;
    }

    protected T getSignalValueUnsafe() {
        return this.signalValue;
    }

    protected void setSignalValue(T value) {
        this.assertLockHeld();
        this.signalValue = value;
        ++this.version;
        List<TransientListener> copy = List.copyOf(this.listeners);
        this.listeners.clear();
        for (TransientListener listener : copy) {
            if (!listener.invoke(false)) continue;
            this.listeners.add(listener);
        }
    }

    private UsageTracker.Usage createUsage() {
        this.assertLockHeld();
        final int originalVersion = this.version;
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                AbstractLocalSignal.this.lock.lock();
                try {
                    boolean bl = AbstractLocalSignal.this.version != originalVersion;
                    return bl;
                }
                finally {
                    AbstractLocalSignal.this.lock.unlock();
                }
            }

            @Override
            public CleanupCallback onNextChange(TransientListener listener) {
                AbstractLocalSignal.this.lock.lock();
                try {
                    if (this.hasChanges() && !listener.invoke(true)) {
                        CleanupCallback cleanupCallback = () -> {};
                        return cleanupCallback;
                    }
                    AbstractLocalSignal.this.listeners.add(listener);
                    CleanupCallback cleanupCallback = () -> {
                        AbstractLocalSignal.this.lock.lock();
                        try {
                            AbstractLocalSignal.this.listeners.remove(listener);
                        }
                        finally {
                            AbstractLocalSignal.this.lock.unlock();
                        }
                    };
                    return cleanupCallback;
                }
                finally {
                    AbstractLocalSignal.this.lock.unlock();
                }
            }
        };
    }

    ReentrantLock getLock() {
        return this.lock;
    }
}

