/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.function.CleanupCallback;
import com.vaadin.signals.function.SerializableRunnable;
import com.vaadin.signals.function.ValueSupplier;
import com.vaadin.signals.impl.TransientListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

public class UsageTracker {
    public static final Usage NO_USAGE = new Usage(){

        @Override
        public boolean hasChanges() {
            return false;
        }

        @Override
        public CleanupCallback onNextChange(TransientListener listener) {
            return () -> {};
        }
    };
    private static final ThreadLocal<UsageRegistrar> currentTracker = new ThreadLocal();

    private UsageTracker() {
    }

    public static Usage track(SerializableRunnable task) {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        UsageTracker.track(task, usages::add);
        int usageSize = usages.size();
        if (usageSize == 0) {
            return NO_USAGE;
        }
        if (usageSize == 1) {
            return (Usage)usages.iterator().next();
        }
        return new CombinedUsage(usages);
    }

    public static void track(SerializableRunnable task, UsageRegistrar tracker) {
        assert (task != null);
        assert (tracker != null);
        UsageTracker.track(() -> {
            task.run();
            return null;
        }, tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T track(Supplier<T> task, UsageRegistrar tracker) {
        assert (task != null);
        assert (tracker != null);
        UsageRegistrar previousTracker = currentTracker.get();
        try {
            currentTracker.set(tracker);
            T t = task.get();
            return t;
        }
        finally {
            currentTracker.set(previousTracker);
        }
    }

    public static <T> T untracked(ValueSupplier<T> task) {
        UsageRegistrar previousTracker = currentTracker.get();
        if (previousTracker == null) {
            return task.supply();
        }
        try {
            currentTracker.remove();
            T t = task.supply();
            return t;
        }
        finally {
            currentTracker.set(previousTracker);
        }
    }

    public static void registerUsage(Usage usage) {
        UsageRegistrar tracker = currentTracker.get();
        assert (tracker != null);
        tracker.register(usage);
    }

    public static boolean isActive() {
        return currentTracker.get() != null;
    }

    @FunctionalInterface
    public static interface UsageRegistrar
    extends Serializable {
        public void register(Usage var1);
    }

    public static interface Usage
    extends Serializable {
        public boolean hasChanges();

        public CleanupCallback onNextChange(TransientListener var1);
    }

    static final class CombinedUsage
    implements Usage {
        private final Collection<Usage> usages;

        CombinedUsage(Collection<Usage> usages) {
            this.usages = usages;
        }

        @Override
        public boolean hasChanges() {
            return this.usages.stream().anyMatch(Usage::hasChanges);
        }

        @Override
        public CleanupCallback onNextChange(final TransientListener listener) {
            return new CleanupCallback(){
                final Object lock = new Object();
                final Collection<CleanupCallback> cleanups = new ArrayList<CleanupCallback>();
                boolean closed = false;
                {
                    Object object = this.lock;
                    synchronized (object) {
                        for (Usage usage : usages) {
                            TransientListener usageListener = new TransientListener(){

                                @Override
                                public boolean invoke(boolean immediate) {
                                    return this.onChange(immediate);
                                }
                            };
                            CleanupCallback cleanup = usage.onNextChange(usageListener);
                            if (this.closed) {
                                cleanup.cleanup();
                                break;
                            }
                            this.cleanups.add(cleanup);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean onChange(boolean immediate) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.closed) {
                            return false;
                        }
                        boolean listenToNext = listener.invoke(immediate);
                        if (!listenToNext) {
                            this.close();
                        }
                        return listenToNext;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void close() {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.closed) {
                            return;
                        }
                        this.closed = true;
                    }
                    this.cleanups.forEach(CleanupCallback::cleanup);
                    this.cleanups.clear();
                }

                @Override
                public void cleanup() {
                    this.close();
                }
            };
        }
    }
}

