/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.WritableSignal;
import com.vaadin.signals.function.SignalMapper;
import com.vaadin.signals.function.SignalUpdater;
import com.vaadin.signals.function.ValueMerger;
import com.vaadin.signals.operations.CancelableOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.Objects;

public class MappedWritableSignal<P, C>
implements WritableSignal<C> {
    private final WritableSignal<P> parent;
    private final SignalMapper<P, C> getter;
    private final ValueMerger<P, C> merger;

    public MappedWritableSignal(WritableSignal<P> parent, SignalMapper<P, C> getter, ValueMerger<P, C> merger) {
        this.parent = Objects.requireNonNull(parent);
        this.getter = Objects.requireNonNull(getter);
        this.merger = Objects.requireNonNull(merger);
    }

    @Override
    public C value() {
        return this.getter.map(this.parent.value());
    }

    @Override
    public C peek() {
        return this.getter.map(this.parent.peek());
    }

    @Override
    public SignalOperation<C> value(C newChildValue) {
        return this.parent.update((T parentValue) -> this.merger.merge(parentValue, newChildValue)).map(oldParent -> this.getter.map(oldParent));
    }

    @Override
    public SignalOperation<Void> replace(C expectedValue, C newValue) {
        Object originalParentValue = this.parent.peek();
        C oldChildValue = this.getter.map(originalParentValue);
        if (!Objects.equals(oldChildValue, expectedValue)) {
            return new SignalOperation<Void>(new SignalOperation.Error("Unexpected child value"));
        }
        return this.parent.replace(originalParentValue, this.merger.merge(originalParentValue, newValue));
    }

    @Override
    public CancelableOperation<C> update(SignalUpdater<C> childUpdater) {
        Objects.requireNonNull(childUpdater);
        return this.parent.update((T parentValue) -> {
            C currentChildValue = this.getter.map(parentValue);
            C newChildValue = childUpdater.update(currentChildValue);
            return this.merger.merge(parentValue, newChildValue);
        }).map(oldParent -> this.getter.map(oldParent));
    }
}

