/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.function.CleanupCallback;
import com.vaadin.signals.function.EffectAction;
import com.vaadin.signals.function.SignalComputation;
import com.vaadin.signals.function.SignalMapper;
import com.vaadin.signals.function.TransactionTask;
import com.vaadin.signals.function.ValueSupplier;
import com.vaadin.signals.impl.ComputedSignal;
import com.vaadin.signals.impl.Effect;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.UsageTracker;
import com.vaadin.signals.operations.TransactionOperation;
import java.io.Serializable;
import java.util.Objects;

@FunctionalInterface
public interface Signal<T>
extends Serializable {
    public T value();

    default public T peek() {
        return (T)Signal.untracked(() -> this.value());
    }

    default public <C> Signal<C> map(SignalMapper<T, C> mapper) {
        return () -> mapper.map(this.value());
    }

    public static CleanupCallback effect(EffectAction action) {
        Effect effect = new Effect(Objects.requireNonNull(action));
        return effect::dispose;
    }

    public static <T> Signal<T> computed(SignalComputation<T> computation) {
        return new ComputedSignal<T>(computation);
    }

    public static Signal<Boolean> not(Signal<Boolean> signal) {
        return Objects.requireNonNull(signal).map(value -> value == null ? null : Boolean.valueOf(value == false));
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static <T> T runWithoutTransaction(ValueSupplier<T> task) {
        return Transaction.runWithoutTransaction(task);
    }

    public static void runWithoutTransaction(TransactionTask task) {
        Transaction.runWithoutTransaction(task);
    }

    public static <T> T untracked(ValueSupplier<T> task) {
        return UsageTracker.untracked(task);
    }
}

