/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.Id;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.CommandResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandsAndHandlers {
    private final List<SignalCommand> commands = new ArrayList<SignalCommand>();
    private final Map<Id, CommandResultHandler> resultHandlers = new HashMap<Id, CommandResultHandler>();

    public CommandsAndHandlers() {
    }

    public CommandsAndHandlers(List<SignalCommand> commands, Map<Id, CommandResultHandler> resultHandlers) {
        this.commands.addAll(commands);
        this.resultHandlers.putAll(resultHandlers);
    }

    public CommandsAndHandlers(SignalCommand command, CommandResultHandler resultHandler) {
        assert (command != null);
        this.commands.add(command);
        if (resultHandler != null) {
            this.resultHandlers.put(command.commandId(), resultHandler);
        }
    }

    public void removeHandledCommands(Collection<Id> handledCommandIds) {
        this.commands.removeIf(command -> handledCommandIds.contains(command.commandId()));
    }

    public void notifyResultHandlers(Map<Id, CommandResult> results) {
        this.notifyResultHandlers(results, this.commands);
    }

    public void notifyResultHandlers(Map<Id, CommandResult> results, List<SignalCommand> commandOrder) {
        for (SignalCommand command : commandOrder) {
            CommandResultHandler handler;
            if (command instanceof SignalCommand.TransactionCommand) {
                SignalCommand.TransactionCommand tx = (SignalCommand.TransactionCommand)command;
                this.notifyResultHandlers(results, tx.commands());
            }
            if ((handler = this.resultHandlers.remove(command.commandId())) == null) continue;
            handler.handle(results.get(command.commandId()));
        }
    }

    public List<SignalCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public Map<Id, CommandResultHandler> getResultHandlers() {
        return Collections.unmodifiableMap(this.resultHandlers);
    }

    public void add(CommandsAndHandlers other) {
        this.commands.addAll(other.commands);
        this.resultHandlers.putAll(other.resultHandlers);
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    @FunctionalInterface
    public static interface CommandResultHandler {
        public void handle(CommandResult var1);
    }
}

