/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.AbstractSignal;
import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.function.CommandValidator;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.SynchronousSignalTree;
import com.vaadin.signals.operations.InsertOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListSignal<T>
extends AbstractSignal<List<ValueSignal<T>>> {
    private final Class<T> elementType;

    public ListSignal(Class<T> elementType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, elementType);
    }

    protected ListSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> elementType) {
        super(tree, id, validator);
        this.elementType = Objects.requireNonNull(elementType);
    }

    private ValueSignal<T> child(Id childId) {
        return new ValueSignal<T>(this.tree(), childId, this.validator(), this.elementType);
    }

    @Override
    protected List<ValueSignal<T>> extractValue(Node.Data data) {
        if (data == null) {
            return List.of();
        }
        return ListSignal.children(data, this::child);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.listChildren();
    }

    public InsertOperation<ValueSignal<T>> insertFirst(T value) {
        return this.insertAt(value, ListPosition.first());
    }

    static <T extends Signal<?>> List<T> children(Node.Data node, Function<Id, T> factory) {
        return node.listChildren().stream().map(factory).toList();
    }

    public InsertOperation<ValueSignal<T>> insertLast(T value) {
        return this.insertAt(value, ListPosition.last());
    }

    public InsertOperation<ValueSignal<T>> insertAt(T value, ListPosition at) {
        return this.submitInsert(new SignalCommand.InsertCommand(Id.random(), this.id(), null, ListSignal.toJson(value), Objects.requireNonNull(at)), this::child);
    }

    public SignalOperation<Void> moveTo(AbstractSignal<T> child, ListPosition to) {
        SignalCommand.PositionCondition verifyChild = new SignalCommand.PositionCondition(Id.random(), this.id(), child.id(), new ListPosition(null, null));
        SignalCommand.AdoptAtCommand adopt = new SignalCommand.AdoptAtCommand(Id.random(), this.id(), child.id(), Objects.requireNonNull(to));
        return this.submit(new SignalCommand.TransactionCommand(Id.random(), List.of(verifyChild, adopt)));
    }

    @Override
    public SignalOperation<Void> remove(ValueSignal<T> child) {
        return super.remove(child);
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    public SignalOperation<Void> verifyPosition(AbstractSignal<?> child, ListPosition expectedPosition) {
        return this.submit(new SignalCommand.PositionCondition(Id.random(), this.id(), child.id(), Objects.requireNonNull(expectedPosition)));
    }

    public SignalOperation<Void> verifyChild(AbstractSignal<?> child) {
        return this.verifyPosition(child, new ListPosition(null, null));
    }

    public ListSignal<T> withValidator(CommandValidator validator) {
        return new ListSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.elementType);
    }

    public ListSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public NodeSignal asNode() {
        return super.asNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ListSignal)) return false;
        ListSignal other = (ListSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.elementType, other.elementType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.elementType);
    }

    public String toString() {
        return ((List)this.peek()).stream().map(AbstractSignal::peek).map(Objects::toString).collect(Collectors.joining(", ", "ListSignal[", "]"));
    }

    public record ListPosition(Id after, Id before) {
        public static ListPosition first() {
            return new ListPosition(Id.EDGE, null);
        }

        public static ListPosition last() {
            return new ListPosition(null, Id.EDGE);
        }

        public static ListPosition after(AbstractSignal<?> after) {
            return new ListPosition(ListPosition.idOf(after), null);
        }

        public static ListPosition before(AbstractSignal<?> before) {
            return new ListPosition(null, ListPosition.idOf(before));
        }

        public static ListPosition between(AbstractSignal<?> after, AbstractSignal<?> before) {
            return new ListPosition(ListPosition.idOf(after), ListPosition.idOf(before));
        }

        private static Id idOf(AbstractSignal<?> signal) {
            if (signal == null) {
                return Id.EDGE;
            }
            return signal.id();
        }
    }
}

