/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.SignalEnvironment;
import com.vaadin.signals.function.CleanupCallback;
import com.vaadin.signals.function.CommandValidator;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.StagedTransaction;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TransientListener;
import com.vaadin.signals.impl.TreeRevision;
import com.vaadin.signals.impl.UsageTracker;
import com.vaadin.signals.operations.InsertOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.Objects;
import java.util.concurrent.Executor;
import tools.jackson.core.JacksonException;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

public abstract class AbstractSignal<T>
implements Signal<T> {
    private final SignalTree tree;
    private final Id id;
    private final CommandValidator validator;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final CommandValidator ANYTHING_GOES = CommandValidator.ACCEPT_ALL;

    protected AbstractSignal(SignalTree tree, Id id, CommandValidator validator) {
        this.tree = Objects.requireNonNull(tree);
        this.validator = Objects.requireNonNull(validator);
        this.id = Objects.requireNonNull(id);
    }

    protected Node.Data data(TreeRevision revision) {
        return revision.data(this.id()).orElse(null);
    }

    protected Node.Data data(Transaction transaction) {
        return this.data(transaction.read(this.tree()));
    }

    @Override
    public T value() {
        Transaction transaction = Transaction.getCurrent();
        Node.Data data = this.data(transaction);
        if (transaction instanceof StagedTransaction && data != null) {
            this.submit(new SignalCommand.LastUpdateCondition(Id.random(), this.id(), data.lastUpdate()));
        }
        T value = this.extractValue(data);
        if (UsageTracker.isActive()) {
            UsageTracker.registerUsage(this.createUsage(transaction));
        }
        return value;
    }

    @Override
    public T peek() {
        return this.extractValue(this.data(Transaction.getCurrent()));
    }

    public T peekConfirmed() {
        return this.extractValue(this.data(this.tree().confirmed()));
    }

    protected CommandValidator validator() {
        return this.validator;
    }

    protected CommandValidator mergeValidators(CommandValidator validator) {
        CommandValidator own = this.validator();
        if (own == ANYTHING_GOES) {
            return validator;
        }
        if (validator == ANYTHING_GOES) {
            return own;
        }
        return own.and(validator);
    }

    protected abstract T extractValue(Node.Data var1);

    protected abstract Object usageChangeValue(Node.Data var1);

    boolean isValid(SignalCommand command) {
        if (command instanceof SignalCommand.ConditionCommand) {
            return true;
        }
        if (command instanceof SignalCommand.TransactionCommand) {
            SignalCommand.TransactionCommand tx = (SignalCommand.TransactionCommand)command;
            return tx.commands().stream().allMatch(this::isValid);
        }
        return this.validator().isValid(command);
    }

    protected <R, O extends SignalOperation<R>> O submit(SignalCommand command, ResultConverter<R> resultConverter, O operation) {
        assert (command instanceof SignalCommand.RemoveCommand || this.id().equals(command.targetNodeId()));
        if (!this.isValid(command)) {
            throw new UnsupportedOperationException();
        }
        Executor notifier = SignalEnvironment.getCurrentResultNotifier();
        Transaction.getCurrent().include(this.tree(), command, result -> operation.result().completeAsync(() -> {
            if (result instanceof CommandResult.Accept) {
                CommandResult.Accept accept = (CommandResult.Accept)result;
                return new SignalOperation.Result(resultConverter.convert(accept));
            }
            if (result instanceof CommandResult.Reject) {
                CommandResult.Reject reject = (CommandResult.Reject)result;
                return new SignalOperation.Error(reject.reason());
            }
            throw new RuntimeException("Unsupported result type: " + String.valueOf(result));
        }, notifier));
        return operation;
    }

    protected <O extends SignalOperation<Void>> O submitVoidOperation(SignalCommand command, O operation) {
        return this.submit(command, success -> null, operation);
    }

    protected <I extends AbstractSignal<?>> InsertOperation<I> submitInsert(SignalCommand command, ChildSignalFactory<I> childFactory) {
        return this.submitVoidOperation(command, new InsertOperation<I>(childFactory.create(command.commandId())));
    }

    protected <R> SignalOperation<R> submit(SignalCommand command, ResultConverter<R> resultConverter) {
        return this.submit(command, resultConverter, new SignalOperation());
    }

    protected SignalOperation<Void> submit(SignalCommand command) {
        return this.submitVoidOperation(command, new SignalOperation());
    }

    public Id id() {
        return this.id;
    }

    protected SignalTree tree() {
        return this.tree;
    }

    protected UsageTracker.Usage createUsage(Transaction transaction) {
        Node.Data data = this.data(transaction);
        if (data == null) {
            return UsageTracker.NO_USAGE;
        }
        final Object originalValue = this.usageChangeValue(data);
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                Node.Data currentData = AbstractSignal.this.data(Transaction.getCurrent());
                return currentData != null && !Objects.equals(originalValue, AbstractSignal.this.usageChangeValue(currentData));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CleanupCallback onNextChange(TransientListener listener) {
                SignalTree tree = AbstractSignal.this.tree();
                tree.getLock().lock();
                try {
                    boolean listenToNext;
                    if (this.hasChanges() && !(listenToNext = listener.invoke(true))) {
                        CleanupCallback cleanupCallback = () -> {};
                        return cleanupCallback;
                    }
                    CleanupCallback cleanupCallback = tree.observeNextChange(AbstractSignal.this.id(), immediate -> {
                        if (this.hasChanges()) {
                            return listener.invoke(immediate);
                        }
                        return true;
                    });
                    return cleanupCallback;
                }
                finally {
                    tree.getLock().unlock();
                }
            }
        };
    }

    protected NodeSignal asNode() {
        assert (!(this instanceof NodeSignal));
        return new NodeSignal(this.tree(), this.id(), this.validator());
    }

    protected SignalOperation<Void> clear() {
        return this.submit(new SignalCommand.ClearCommand(Id.random(), this.id()));
    }

    protected SignalOperation<Void> remove(AbstractSignal<?> child) {
        return this.submit(new SignalCommand.RemoveCommand(Id.random(), child.id(), this.id()));
    }

    protected static JsonNode toJson(Object value) {
        return OBJECT_MAPPER.valueToTree(value);
    }

    protected static <T> T fromJson(JsonNode value, Class<T> targetType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)value, targetType);
        }
        catch (JacksonException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> T nodeValue(Node node, Class<T> valueType) {
        assert (node instanceof Node.Data);
        return AbstractSignal.fromJson(((Node.Data)node).value(), valueType);
    }

    @FunctionalInterface
    protected static interface ResultConverter<T> {
        public T convert(CommandResult.Accept var1);
    }

    @FunctionalInterface
    protected static interface ChildSignalFactory<I extends AbstractSignal<?>> {
        public I create(Id var1);
    }
}

