/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.AbstractSignal;
import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.SynchronousSignalTree;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.operations.CancelableOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ValueSignal<T>
extends AbstractSignal<T> {
    private final Class<T> valueType;

    public ValueSignal(T initialValue) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, initialValue.getClass());
        this.value(initialValue);
    }

    public ValueSignal(Class<T> valueType) {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES, Objects.requireNonNull(valueType));
    }

    protected ValueSignal(SignalTree tree, Id id, Predicate<SignalCommand> validator, Class<T> valueType) {
        super(tree, id, validator);
        this.valueType = Objects.requireNonNull(valueType);
    }

    public SignalOperation<T> value(T value) {
        assert (value == null || this.valueType.isInstance(value));
        return this.submit(new SignalCommand.SetCommand(Id.random(), this.id(), ValueSignal.toJson(value)), success -> ValueSignal.nodeValue(success.onlyUpdate().oldNode(), this.valueType));
    }

    @Override
    protected T extractValue(Node.Data data) {
        if (data == null) {
            return null;
        }
        return ValueSignal.nodeValue(data, this.valueType);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.value();
    }

    public SignalOperation<Void> replace(T expectedValue, T newValue) {
        SignalCommand.ValueCondition condition = new SignalCommand.ValueCondition(Id.random(), this.id(), ValueSignal.toJson(expectedValue));
        SignalCommand.SetCommand set = new SignalCommand.SetCommand(Id.random(), this.id(), ValueSignal.toJson(newValue));
        return this.submit(new SignalCommand.TransactionCommand(Id.random(), List.of(condition, set)));
    }

    public CancelableOperation<T> update(UnaryOperator<T> updater) {
        CancelableOperation operation = new CancelableOperation();
        this.tryUpdate(updater, operation);
        return operation;
    }

    private void tryUpdate(UnaryOperator<T> updater, CancelableOperation<T> operation) {
        if (operation.isCancelled()) {
            operation.result().cancel(false);
            return;
        }
        SignalOperation setOperation = Transaction.runInTransaction(() -> {
            Object value = this.peek();
            this.verifyValue(value);
            Object newValue = updater.apply(value);
            return this.value(newValue);
        }).returnValue();
        setOperation.result().whenComplete((result, error) -> {
            if (error != null) {
                operation.result().completeExceptionally((Throwable)error);
            } else if (result.successful()) {
                operation.result().complete((SignalOperation.ResultOrError<SignalOperation.ResultOrError>)result);
            } else {
                this.tryUpdate(updater, operation);
            }
        });
    }

    public SignalOperation<Void> verifyValue(T expectedValue) {
        return this.submit(new SignalCommand.ValueCondition(Id.random(), this.id(), ValueSignal.toJson(expectedValue)));
    }

    public ValueSignal<T> withValidator(Predicate<SignalCommand> validator) {
        return new ValueSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.valueType);
    }

    public ValueSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public NodeSignal asNode() {
        return super.asNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ValueSignal)) return false;
        ValueSignal other = (ValueSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.valueType, other.valueType)) return false;
        if (!Objects.equals(this.getClass(), other.getClass())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.valueType);
    }

    public String toString() {
        return "ValueSignal[" + String.valueOf(this.peek()) + "]";
    }
}

