/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.AbstractSignal;
import com.vaadin.signals.Id;
import com.vaadin.signals.ListSignal;
import com.vaadin.signals.MapSignal;
import com.vaadin.signals.Node;
import com.vaadin.signals.NumberSignal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.SynchronousSignalTree;
import com.vaadin.signals.operations.InsertOperation;
import com.vaadin.signals.operations.SignalOperation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tools.jackson.databind.JsonNode;

public class NodeSignal
extends AbstractSignal<NodeSignalState> {
    public NodeSignal() {
        this(new SynchronousSignalTree(false), Id.ZERO, ANYTHING_GOES);
    }

    protected NodeSignal(SignalTree tree, Id id, Predicate<SignalCommand> validator) {
        super(tree, id, validator);
    }

    private NodeSignal child(Id id) {
        return new NodeSignal(this.tree(), id, this.validator());
    }

    @Override
    protected NodeSignalState extractValue(Node.Data data) {
        if (data == null) {
            return null;
        }
        Id parentId = data.parent();
        return new NodeSignalState(data.value(), parentId != null ? this.child(parentId) : null, ListSignal.children(data, this::child), MapSignal.children(data, this::child));
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.lastUpdate();
    }

    public <T> ValueSignal<T> asValue(Class<T> valueType) {
        return new ValueSignal<T>(this.tree(), this.id(), this.validator(), valueType);
    }

    public NumberSignal asNumber() {
        return new NumberSignal(this.tree(), this.id(), this.validator());
    }

    public <T> ListSignal<T> asList(Class<T> elementType) {
        return new ListSignal<T>(this.tree(), this.id(), this.validator(), elementType);
    }

    public <T> MapSignal<T> asMap(Class<T> elementType) {
        return new MapSignal<T>(this.tree(), this.id(), this.validator(), elementType);
    }

    public InsertOperation<NodeSignal> insertChildWithValue(Object value, ListSignal.ListPosition at) {
        return this.submitInsert(new SignalCommand.InsertCommand(Id.random(), this.id(), null, NodeSignal.toJson(value), at), this::child);
    }

    public InsertOperation<NodeSignal> insertChild(ListSignal.ListPosition at) {
        return this.insertChildWithValue(null, at);
    }

    public SignalOperation<Void> putChildWithValue(String key, Object value) {
        return this.submit(new SignalCommand.PutCommand(Id.random(), this.id(), Objects.requireNonNull(key), NodeSignal.toJson(value)));
    }

    public InsertOperation<NodeSignal> putChildIfAbsent(String key) {
        return this.submitInsert(new SignalCommand.PutIfAbsentCommand(Id.random(), this.id(), null, Objects.requireNonNull(key), null), this::child);
    }

    public SignalOperation<Void> adoptAt(AbstractSignal<?> node, ListSignal.ListPosition at) {
        return this.submit(new SignalCommand.AdoptAtCommand(Id.random(), this.id(), node.id(), Objects.requireNonNull(at)));
    }

    public SignalOperation<Void> adoptAs(AbstractSignal<?> signal, String key) {
        return this.submit(new SignalCommand.AdoptAsCommand(Id.random(), this.id(), signal.id(), Objects.requireNonNull(key)));
    }

    public SignalOperation<Void> removeChild(NodeSignal child) {
        return super.remove(child);
    }

    public SignalOperation<Void> removeChild(String key) {
        return this.submit(new SignalCommand.RemoveByKeyCommand(Id.random(), this.id(), Objects.requireNonNull(key)));
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    public NodeSignal withValidator(Predicate<SignalCommand> validator) {
        return new NodeSignal(this.tree(), this.id(), this.mergeValidators(validator));
    }

    public NodeSignal asReadonly() {
        return this.withValidator(anything -> false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NodeSignal)) return false;
        NodeSignal other = (NodeSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeSignal[");
        NodeSignalState value = (NodeSignalState)this.peek();
        if (value != null) {
            boolean needsComma = false;
            if (value.value != null) {
                builder.append("value: ").append(value.value);
                needsComma = true;
            }
            if (!value.listChildren.isEmpty()) {
                if (needsComma) {
                    builder.append(", ");
                }
                builder.append("listChildren: ").append(value.listChildren.stream().map(NodeSignal::toString).collect(Collectors.joining(", ", "[", "]")));
                needsComma = true;
            }
            if (!value.mapChildren.isEmpty()) {
                if (needsComma) {
                    builder.append(", ");
                }
                builder.append("mapChildren: ").append(value.mapChildren.entrySet().stream().map((? super T entry) -> (String)entry.getKey() + " = " + entry.getValue()).collect(Collectors.joining(", ", "[", "]")));
            }
        }
        builder.append(']');
        return builder.toString();
    }

    public static class NodeSignalState {
        private final JsonNode value;
        private final NodeSignal parent;
        private final List<NodeSignal> listChildren;
        private final Map<String, NodeSignal> mapChildren;

        public NodeSignalState(JsonNode value, NodeSignal parent, List<NodeSignal> listChildren, Map<String, NodeSignal> mapChildren) {
            this.value = value;
            this.parent = parent;
            this.listChildren = listChildren;
            this.mapChildren = mapChildren;
        }

        public <T> T value(Class<T> valueType) {
            return AbstractSignal.fromJson(this.value, valueType);
        }

        public NodeSignal parent() {
            return this.parent;
        }

        public List<NodeSignal> listChildren() {
            return this.listChildren;
        }

        public Map<String, NodeSignal> mapChildren() {
            return this.mapChildren;
        }
    }
}

