/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.Id;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.CommandsAndHandlers;
import com.vaadin.signals.impl.MutableTreeRevision;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TreeRevision;
import com.vaadin.signals.operations.SignalOperation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class StagedTransaction
extends Transaction {
    private final Map<SignalTree, TreeState> openTrees = new HashMap<SignalTree, TreeState>();
    private boolean failing = false;
    private boolean committing = false;
    private final Transaction outer;

    public StagedTransaction(Transaction outer) {
        assert (outer != null);
        this.outer = outer;
    }

    @Override
    protected void commit(Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
        assert (!this.committing);
        this.committing = true;
        if (this.openTrees.isEmpty()) {
            resultHandler.accept(new SignalOperation.Result<Object>(null));
            return;
        }
        Transaction transaction = this.outer;
        if (transaction instanceof StagedTransaction) {
            StagedTransaction outerTx = (StagedTransaction)transaction;
            ResultCollector collector = new ResultCollector(this.openTrees.keySet(), resultHandler);
            for (SignalTree tree : this.openTrees.keySet()) {
                outerTx.include(tree, this.createChange(tree, collector), true);
            }
        } else {
            this.commitTwoPhase(resultHandler);
            for (SignalTree tree : this.openTrees.keySet()) {
                CommandsAndHandlers staged = this.openTrees.get((Object)tree).staged;
                SignalCommand.TransactionCommand command = new SignalCommand.TransactionCommand(Id.random(), staged.getCommands());
                this.outer.include(tree, command, null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTwoPhase(Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
        List<SignalTree> trees = this.openTrees.entrySet().stream().filter(entry -> !((TreeState)entry.getValue()).staged.isEmpty()).map(Map.Entry::getKey).sorted(Comparator.comparing(SignalTree::id)).toList();
        ResultCollector collector = new ResultCollector(trees, resultHandler);
        try {
            trees.forEach(tree -> tree.getLock().lock());
            List<SignalTree.PendingCommit> pendingCommits = trees.stream().map(tree -> tree.prepareCommit(this.createChange((SignalTree)tree, collector))).toList();
            if (pendingCommits.stream().allMatch(SignalTree.PendingCommit::canCommit)) {
                pendingCommits.forEach(SignalTree.PendingCommit::applyChanges);
                pendingCommits.forEach(SignalTree.PendingCommit::publishChanges);
            } else {
                pendingCommits.forEach(SignalTree.PendingCommit::markAsAborted);
            }
        }
        finally {
            trees.forEach(tree -> tree.getLock().unlock());
        }
    }

    private CommandsAndHandlers createChange(SignalTree tree, ResultCollector collector) {
        Id txId = Id.random();
        CommandsAndHandlers change = this.openTrees.get((Object)tree).staged;
        HashMap<Id, Consumer<CommandResult>> handlers = new HashMap<Id, Consumer<CommandResult>>(change.getResultHandlers());
        handlers.put(txId, collector.registerDependency(tree));
        return new CommandsAndHandlers(List.of(new SignalCommand.TransactionCommand(txId, change.getCommands())), handlers);
    }

    private TreeState getOrCreateTreeState(SignalTree tree) {
        TreeState treeState = this.openTrees.get(tree);
        if (treeState == null) {
            this.validateTreeTypes(tree);
            treeState = new TreeState(this.outer.read(tree));
            this.openTrees.put(tree, treeState);
        }
        return treeState;
    }

    @Override
    public void include(SignalTree tree, SignalCommand command, Consumer<CommandResult> resultHandler, boolean applyToTree) {
        if (this.committing) {
            this.outer.include(tree, command, resultHandler, applyToTree);
            return;
        }
        this.include(tree, new CommandsAndHandlers(command, resultHandler), applyToTree);
    }

    private void include(SignalTree tree, CommandsAndHandlers commands, boolean applyToTree) {
        TreeState state = this.getOrCreateTreeState(tree);
        if (applyToTree) {
            state.staged.add(commands);
            state.updateRevision(commands.getCommands());
            this.failing |= state.failing;
        } else {
            state.rebase(commands.getCommands());
            this.failing = this.openTrees.values().stream().anyMatch(s -> s.failing);
        }
    }

    @Override
    public TreeRevision read(SignalTree tree) {
        if (this.committing) {
            return this.outer.read(tree);
        }
        TreeState state = this.getOrCreateTreeState(tree);
        return this.failing ? state.base : state.revision;
    }

    private void validateTreeTypes(SignalTree tree) {
        SignalTree.Type treeType = tree.type();
        if (treeType == SignalTree.Type.ASYNCHRONOUS) {
            if (!this.openTreeTypes().allMatch(SignalTree.Type.COMPUTED::equals)) {
                throw new IllegalStateException("An asynchronous signal can only share transaction with computed signals and other asynchronous signals that belong to the same tree.");
            }
        } else if (treeType == SignalTree.Type.SYNCHRONOUS) {
            if (this.openTreeTypes().anyMatch(SignalTree.Type.ASYNCHRONOUS::equals)) {
                throw new IllegalStateException("A synchronous signal cannot share transaction with asynchronous signals.");
            }
        }
    }

    private Stream<SignalTree.Type> openTreeTypes() {
        return this.openTrees.keySet().stream().map(SignalTree::type);
    }

    @Override
    protected void rollback() {
        CommandResult.Reject result = CommandResult.fail("Rolled back");
        for (TreeState state : this.openTrees.values()) {
            HashMap<Id, CommandResult> results = new HashMap<Id, CommandResult>();
            for (SignalCommand command : state.staged.getCommands()) {
                results.put(command.commandId(), result);
            }
            state.staged.notifyResultHandlers(results);
        }
    }

    static class ResultCollector {
        private final HashSet<Object> unresolvedDependencies;
        private final Consumer<SignalOperation.ResultOrError<Void>> resultHandler;
        private final Object lock = new Object();
        private Boolean state = null;

        public ResultCollector(Collection<?> dependencies, Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
            this.unresolvedDependencies = new HashSet(dependencies);
            this.resultHandler = resultHandler;
        }

        public Consumer<CommandResult> registerDependency(Object dependency) {
            assert (this.unresolvedDependencies.contains(dependency));
            return result -> {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.unresolvedDependencies.remove(dependency)) assert (false);
                    if (this.state != null) {
                        return;
                    }
                    if (result instanceof CommandResult.Reject) {
                        CommandResult.Reject error = (CommandResult.Reject)result;
                        this.state = Boolean.FALSE;
                        this.resultHandler.accept(new SignalOperation.Error(error.reason()));
                    } else if (this.unresolvedDependencies.isEmpty()) {
                        this.state = Boolean.TRUE;
                        this.resultHandler.accept(new SignalOperation.Result<Object>(null));
                    }
                }
            };
        }
    }

    static class TreeState {
        final CommandsAndHandlers staged = new CommandsAndHandlers();
        boolean failing = false;
        TreeRevision base;
        MutableTreeRevision revision;

        public TreeState(TreeRevision base) {
            this.base = base;
            this.revision = new MutableTreeRevision(base);
        }

        private MutableTreeRevision mutableBase() {
            TreeRevision treeRevision = this.base;
            if (treeRevision instanceof MutableTreeRevision) {
                MutableTreeRevision mutable = (MutableTreeRevision)treeRevision;
                return mutable;
            }
            MutableTreeRevision mutable = new MutableTreeRevision(this.base);
            this.base = mutable;
            return mutable;
        }

        void rebase(List<SignalCommand> baseCommands) {
            MutableTreeRevision base = this.mutableBase();
            base.apply(baseCommands);
            this.failing = false;
            this.revision = new MutableTreeRevision(base);
            this.updateRevision(this.staged.getCommands());
        }

        void updateRevision(List<SignalCommand> commands) {
            Map<Id, CommandResult> results = this.revision.applyAndGetResults(commands);
            this.failing |= results.values().stream().anyMatch(r -> !r.accepted());
        }
    }
}

