/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.SignalEnvironment;
import com.vaadin.signals.impl.UsageTracker;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class Effect {
    private final Executor dispatcher = SignalEnvironment.getCurrentEffectDispatcher();
    private UsageTracker.Usage dependencies;
    private Runnable registration;
    private Runnable action;
    private final AtomicBoolean invalidateScheduled = new AtomicBoolean(false);

    public Effect(Runnable action) {
        assert (action != null);
        this.action = action;
        this.revalidate();
    }

    private void revalidate() {
        assert (this.registration == null);
        if (this.action == null) {
            return;
        }
        this.dependencies = UsageTracker.track(this.action);
        this.registration = this.dependencies.onNextChange(() -> {
            this.scheduleInvalidate();
            return false;
        });
    }

    private void scheduleInvalidate() {
        if (this.invalidateScheduled.compareAndSet(false, true)) {
            this.dispatcher.execute(this::invalidate);
        }
    }

    private synchronized void invalidate() {
        this.invalidateScheduled.set(false);
        this.clearRegistrations();
        this.revalidate();
    }

    private void clearRegistrations() {
        if (this.registration != null) {
            this.registration.run();
            this.registration = null;
        }
    }

    public synchronized void dispose() {
        this.clearRegistrations();
        this.action = null;
        this.dependencies = null;
    }
}

