/*
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.signals;

/**
 * Exception indicating that an operation could not be performed because a
 * binding is active.
 */
public class BindingActiveException extends IllegalStateException {

    /**
     * Creates a new exception with a default message.
     */
    public BindingActiveException() {
        super("Operation could not be performed because a binding is active.");
    }

    /**
     * Creates a new exception with a custom message.
     *
     * @param message
     *            the custom message
     */
    public BindingActiveException(String message) {
        super(message);
    }
}
