/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;

public abstract class SignalEnvironment {
    private static final List<SignalEnvironment> environments = new CopyOnWriteArrayList<SignalEnvironment>();
    private static final Executor IMMEDIATE_EXECUTOR = Runnable::run;
    private static final Executor EFFECT_DISPATCHER = command -> SignalEnvironment.resolve(SignalEnvironment::getEffectDispatcher, IMMEDIATE_EXECUTOR).execute(command);

    protected abstract boolean isActive();

    protected abstract Executor getResultNotifier();

    protected abstract Executor getEffectDispatcher();

    public static Runnable register(SignalEnvironment environment) {
        environments.add(Objects.requireNonNull(environment));
        return () -> environments.remove(environment);
    }

    private static <T> T resolve(Function<SignalEnvironment, T> getter, T defaultValue) {
        return (T)environments.stream().filter(SignalEnvironment::isActive).map(getter).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }

    public static Executor getCurrentResultNotifier() {
        return SignalEnvironment.resolve(SignalEnvironment::getResultNotifier, IMMEDIATE_EXECUTOR);
    }

    public static Executor getDefaultEffectDispatcher() {
        return EFFECT_DISPATCHER;
    }
}

