/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vaadin.signals.Id;
import com.vaadin.signals.ListSignal;
import com.vaadin.signals.Node;
import java.util.List;
import java.util.Map;
import tools.jackson.databind.JsonNode;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ValueCondition.class, name="value"), @JsonSubTypes.Type(value=PositionCondition.class, name="pos"), @JsonSubTypes.Type(value=KeyCondition.class, name="key"), @JsonSubTypes.Type(value=LastUpdateCondition.class, name="last"), @JsonSubTypes.Type(value=AdoptAtCommand.class, name="at"), @JsonSubTypes.Type(value=AdoptAsCommand.class, name="as"), @JsonSubTypes.Type(value=IncrementCommand.class, name="inc"), @JsonSubTypes.Type(value=ClearCommand.class, name="clear"), @JsonSubTypes.Type(value=RemoveByKeyCommand.class, name="removeKey"), @JsonSubTypes.Type(value=PutCommand.class, name="put"), @JsonSubTypes.Type(value=PutIfAbsentCommand.class, name="putAbsent"), @JsonSubTypes.Type(value=InsertCommand.class, name="insert"), @JsonSubTypes.Type(value=SetCommand.class, name="set"), @JsonSubTypes.Type(value=RemoveCommand.class, name="remove"), @JsonSubTypes.Type(value=ClearOwnerCommand.class, name="clearOwner"), @JsonSubTypes.Type(value=TransactionCommand.class, name="tx"), @JsonSubTypes.Type(value=SnapshotCommand.class, name="snapshot")})
public sealed interface SignalCommand {
    public Id commandId();

    public Id targetNodeId();

    public record SnapshotCommand(Id commandId, Map<Id, Node> nodes) implements GlobalCommand
    {
    }

    public record TransactionCommand(Id commandId, List<SignalCommand> commands) implements GlobalCommand
    {
    }

    public record ClearOwnerCommand(Id commandId, Id ownerId) implements GlobalCommand
    {
    }

    public record RemoveCommand(Id commandId, Id targetNodeId, Id expectedParentId) implements SignalCommand
    {
    }

    public record SetCommand(Id commandId, Id targetNodeId, JsonNode value) implements ValueCommand
    {
    }

    public record InsertCommand(Id commandId, Id targetNodeId, Id scopeOwner, JsonNode value, ListSignal.ListPosition position) implements ValueCommand,
    ScopeOwnerCommand
    {
    }

    public record PutIfAbsentCommand(Id commandId, Id targetNodeId, Id scopeOwner, String key, JsonNode value) implements ValueCommand,
    KeyCommand,
    ScopeOwnerCommand
    {
    }

    public record PutCommand(Id commandId, Id targetNodeId, String key, JsonNode value) implements ValueCommand,
    KeyCommand
    {
    }

    public record RemoveByKeyCommand(Id commandId, Id targetNodeId, String key) implements KeyCommand
    {
    }

    public record ClearCommand(Id commandId, Id targetNodeId) implements SignalCommand
    {
    }

    public record IncrementCommand(Id commandId, Id targetNodeId, double delta) implements SignalCommand
    {
    }

    public record AdoptAtCommand(Id commandId, Id targetNodeId, Id childId, ListSignal.ListPosition position) implements SignalCommand
    {
    }

    public record AdoptAsCommand(Id commandId, Id targetNodeId, Id childId, String key) implements KeyCommand
    {
    }

    public record LastUpdateCondition(Id commandId, Id targetNodeId, Id expectedLastUpdate) implements ConditionCommand
    {
    }

    public record KeyCondition(Id commandId, Id targetNodeId, String key, Id expectedChild) implements ConditionCommand
    {
    }

    public record PositionCondition(Id commandId, Id targetNodeId, Id childId, ListSignal.ListPosition position) implements ConditionCommand
    {
    }

    public record ValueCondition(Id commandId, Id targetNodeId, JsonNode expectedValue) implements ConditionCommand
    {
    }

    public static sealed interface GlobalCommand
    extends SignalCommand
    permits ClearOwnerCommand, TransactionCommand, SnapshotCommand {
        @Override
        default public Id targetNodeId() {
            return Id.ZERO;
        }
    }

    public static sealed interface ScopeOwnerCommand
    extends SignalCommand
    permits PutIfAbsentCommand, InsertCommand {
        public Id scopeOwner();
    }

    public static sealed interface ConditionCommand
    extends SignalCommand
    permits ValueCondition, PositionCondition, KeyCondition, LastUpdateCondition {
    }

    public static sealed interface KeyCommand
    extends SignalCommand
    permits AdoptAsCommand, RemoveByKeyCommand, PutCommand, PutIfAbsentCommand {
        public String key();
    }

    public static sealed interface ValueCommand
    extends SignalCommand
    permits PutCommand, PutIfAbsentCommand, InsertCommand, SetCommand {
        public JsonNode value();
    }
}

