/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.impl.TransientListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class UsageTracker {
    public static final Usage NO_USAGE = new Usage(){

        @Override
        public boolean hasChanges() {
            return false;
        }

        @Override
        public Runnable onNextChange(TransientListener listener) {
            return () -> {};
        }
    };
    private static final ThreadLocal<Consumer<Usage>> currentTracker = new ThreadLocal();

    private UsageTracker() {
    }

    public static Usage track(Runnable task) {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        UsageTracker.track(task, usages::add);
        int usageSize = usages.size();
        if (usageSize == 0) {
            return NO_USAGE;
        }
        if (usageSize == 1) {
            return (Usage)usages.iterator().next();
        }
        return new CombinedUsage(usages);
    }

    public static void track(Runnable task, Consumer<Usage> tracker) {
        assert (task != null);
        assert (tracker != null);
        Consumer<Usage> previousTracker = currentTracker.get();
        try {
            currentTracker.set(tracker);
            task.run();
        }
        finally {
            currentTracker.set(previousTracker);
        }
    }

    public static <T> T untracked(Supplier<T> task) {
        Consumer<Usage> previousTracker = currentTracker.get();
        if (previousTracker == null) {
            return task.get();
        }
        try {
            currentTracker.remove();
            T t = task.get();
            return t;
        }
        finally {
            currentTracker.set(previousTracker);
        }
    }

    public static void registerUsage(Usage usage) {
        Consumer<Usage> tracker = currentTracker.get();
        assert (tracker != null);
        tracker.accept(usage);
    }

    public static boolean isActive() {
        return currentTracker.get() != null;
    }

    public static interface Usage {
        public boolean hasChanges();

        public Runnable onNextChange(TransientListener var1);
    }

    static final class CombinedUsage
    implements Usage {
        private final Collection<Usage> usages;

        CombinedUsage(Collection<Usage> usages) {
            this.usages = usages;
        }

        @Override
        public boolean hasChanges() {
            return this.usages.stream().anyMatch(Usage::hasChanges);
        }

        @Override
        public Runnable onNextChange(final TransientListener listener) {
            return new Runnable(){
                final Object lock = new Object();
                final Collection<Runnable> cleanups = new ArrayList<Runnable>();
                boolean closed = false;
                {
                    Object object = this.lock;
                    synchronized (object) {
                        for (Usage usage : usages) {
                            Runnable cleanup = usage.onNextChange(this::onChange);
                            if (this.closed) {
                                cleanup.run();
                                break;
                            }
                            this.cleanups.add(cleanup);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean onChange(boolean immediate) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.closed) {
                            return false;
                        }
                        boolean listenToNext = listener.invoke(immediate);
                        if (!listenToNext) {
                            this.close();
                        }
                        return listenToNext;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void close() {
                    Object object = this.lock;
                    synchronized (object) {
                        this.closed = true;
                        this.cleanups.forEach(Runnable::run);
                        this.cleanups.clear();
                    }
                }

                @Override
                public void run() {
                    this.close();
                }
            };
        }
    }
}

