/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.observability;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.observability.ObservabilityClient;
import com.vaadin.observability.ObservabilityClientConfigurer;
import com.vaadin.observability.ObservabilityHandler;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservabilityServiceInitListener
implements VaadinServiceInitListener {
    static final String CONFIG_PROPERTY_PREFIX = "otel.instrumentation.vaadin.frontend.";

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ObservabilityServiceInitListener.class);
    }

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        ObservabilityServiceInitListener.getLogger().info("Initializing Observability Kit");
        serviceInitEvent.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)response -> {
            Span span = Span.current();
            SpanContext spanContext = span.getSpanContext();
            String traceParent = "00-" + spanContext.getTraceId() + "-" + spanContext.getSpanId() + "-01";
            response.getDocument().head().prependElement("meta").attr("name", "traceparent").attr("content", traceParent);
        });
        ObservabilityClientConfigurer configurer = ObservabilityServiceInitListener.getObservabilityClientConfigurer(serviceInitEvent);
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)event -> {
            UI ui = event.getUI();
            ObservabilityHandler handler = ObservabilityHandler.ensureInstalled(ui);
            ui.getChildren().filter(child -> child instanceof ObservabilityClient).forEach(xva$0 -> ui.remove(new Component[]{xva$0}));
            ObservabilityClient client = new ObservabilityClient(handler.getId());
            if (configurer != null) {
                configurer.configure(client);
            } else {
                ObservabilityServiceInitListener.applyDefaultConfiguration(handler, client);
            }
            if (client.isEnabled()) {
                client.getElement().setProperty("instanceId", handler.getId());
                client.getElement().setProperty("serviceName", handler.getConfigProperty("otel.service.name"));
                client.getElement().setProperty("serviceVersion", handler.getConfigProperty("otel.service.version"));
                ui.add(new Component[]{client});
            } else {
                ObservabilityServiceInitListener.getLogger().debug("Observability Client disabled for UI {} in Vaadin Session {}", (Object)ui.getUIId(), (Object)ui.getSession().getSession().getId());
            }
        });
    }

    private static void applyDefaultConfiguration(ObservabilityHandler handler, ObservabilityClient client) {
        if (ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "enabled", true)) {
            client.setDocumentLoadEnabled(ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "document-load", true));
            client.setUserInteractionEnabled(ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "user-interaction", true));
            client.setXMLHttpRequestEnabled(ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "xml-http-request", true));
            client.setLongTaskEnabled(ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "long-task", true));
            client.setFrontendErrorEnabled(ObservabilityServiceInitListener.isConfigurationFlagEnabled(handler, "frontend-error", true));
            client.setEnabled(client.isDocumentLoadEnabled() || client.isUserInteractionEnabled() || client.isXMLHttpRequestEnabled() || client.isLongTaskEnabled() || client.isFrontendErrorEnabled());
        } else {
            client.setEnabled(false);
        }
    }

    private static boolean isConfigurationFlagEnabled(ObservabilityHandler handler, String key, boolean defaultValue) {
        String value = handler.getConfigProperty(CONFIG_PROPERTY_PREFIX + key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private static ObservabilityClientConfigurer getObservabilityClientConfigurer(ServiceInitEvent serviceInitEvent) {
        ObservabilityClientConfigurer configurer = (ObservabilityClientConfigurer)((Lookup)serviceInitEvent.getSource().getContext().getAttribute(Lookup.class)).lookup(ObservabilityClientConfigurer.class);
        if (configurer != null) {
            ObservabilityServiceInitListener.getLogger().info("Applying custom front-end observability configuration");
        }
        return configurer;
    }
}

