/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.observability;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ObservabilityClientConfiguration {
    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void setDocumentLoadEnabled(boolean var1);

    public boolean isDocumentLoadEnabled();

    public void setUserInteractionEnabled(boolean var1);

    public boolean isUserInteractionEnabled();

    public void setUserInteractionEvents(Collection<String> var1);

    default public void setUserInteractionEvents(String ... events) {
        this.setUserInteractionEvents(Arrays.asList(events));
    }

    public Set<String> getUserInteractionEvents();

    public void setLongTaskEnabled(boolean var1);

    public boolean isLongTaskEnabled();

    public void setFrontendErrorEnabled(boolean var1);

    public boolean isFrontendErrorEnabled();

    public void setXMLHttpRequestEnabled(boolean var1);

    public boolean isXMLHttpRequestEnabled();

    public void setIgnoreVaadinURLs(boolean var1);

    public boolean isIgnoreVaadinURLs();

    public void setIgnoredURLs(Collection<URLPattern> var1);

    default public void setIgnoredURLs(String ... urls) {
        this.setIgnoredURLs(Stream.of(urls).map(ObservabilityClientConfiguration::url).collect(Collectors.toList()));
    }

    public void addIgnoredURL(URLPattern var1);

    default public void addIgnoredURL(String ... url) {
        Stream.of(url).map(ObservabilityClientConfiguration::url).forEach(this::addIgnoredURL);
    }

    default public void addIgnoredURLPattern(String ... pattern) {
        Stream.of(pattern).map(ObservabilityClientConfiguration::urlPattern).forEach(this::addIgnoredURL);
    }

    public List<URLPattern> getIgnoredURLs();

    public static URLPattern url(String url) {
        return new URLPattern(url, true);
    }

    public static URLPattern urlPattern(String regex) {
        return new URLPattern(regex, false);
    }

    public static final class URLPattern
    implements Serializable {
        private final String pattern;
        private final boolean exactMatch;

        public URLPattern(String pattern, boolean exactMatch) {
            this.pattern = Objects.requireNonNull(pattern, "pattern must not be null");
            this.exactMatch = exactMatch;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isExactMatch() {
            return this.exactMatch;
        }

        public String toString() {
            return (this.exactMatch ? "exact" : "regex") + "::" + this.pattern;
        }

        String toInternalFormat() {
            if (this.exactMatch) {
                return this.pattern;
            }
            return "RE:/" + this.pattern + "/";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLPattern that = (URLPattern)o;
            return this.exactMatch == that.exactMatch && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.exactMatch);
        }

        static URLPattern fromInternalFormat(String pattern) {
            if (pattern.length() >= 5 && pattern.startsWith("RE:/") && pattern.endsWith("/")) {
                return new URLPattern(pattern.substring(4, pattern.length() - 1), false);
            }
            return new URLPattern(pattern, true);
        }
    }
}

