/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.observability;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.observability.ObservabilityClientConfiguration;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@NpmPackage.Container(value={@NpmPackage(value="@opentelemetry/sdk-trace-web", version="1.8.0"), @NpmPackage(value="@opentelemetry/instrumentation", version="0.35.0"), @NpmPackage(value="@opentelemetry/instrumentation-document-load", version="0.31.0"), @NpmPackage(value="@opentelemetry/instrumentation-user-interaction", version="0.32.0"), @NpmPackage(value="@opentelemetry/instrumentation-xml-http-request", version="0.34.0"), @NpmPackage(value="@opentelemetry/instrumentation-long-task", version="0.32.0"), @NpmPackage(value="@opentelemetry/exporter-trace-otlp-http", version="0.35.0")})
@Tag(value="vaadin-observability-client")
@JsModule(value="./components/observability-client.ts")
class ObservabilityClient
extends Component
implements ObservabilityClientConfiguration {
    private boolean enabled = true;

    public ObservabilityClient(String identifier) {
        this.getElement().setProperty("instanceId", Objects.requireNonNull(identifier));
        this.setDocumentLoadEnabled(true);
        this.setXMLHttpRequestEnabled(true);
        this.setLongTaskEnabled(true);
        this.setFrontendErrorEnabled(true);
        this.setUserInteractionEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setDocumentLoadEnabled(boolean enabled) {
        this.getElement().setProperty("traceDocumentLoad", enabled);
    }

    @Override
    public boolean isDocumentLoadEnabled() {
        return this.getElement().getProperty("traceDocumentLoad", false);
    }

    @Override
    public void setUserInteractionEnabled(boolean enabled) {
        if (!enabled) {
            this.getElement().removeProperty("traceUserInteraction");
        } else if (!this.isUserInteractionEnabled()) {
            this.setUserInteractionEvents(new String[]{"click"});
        }
    }

    @Override
    public boolean isUserInteractionEnabled() {
        return this.getElement().hasProperty("traceUserInteraction");
    }

    @Override
    public void setUserInteractionEvents(Collection<String> events) {
        if (events.isEmpty()) {
            throw new IllegalArgumentException("At least one event must be configured for UserInteraction instrumentation");
        }
        ArrayList<String> copy = new ArrayList<String>(events);
        copy.removeIf(Objects::isNull);
        this.getElement().setPropertyList("traceUserInteraction", copy);
    }

    @Override
    public Set<String> getUserInteractionEvents() {
        return JsonUtils.stream((JsonArray)((JsonArray)this.getElement().getPropertyRaw("traceUserInteraction"))).map(JsonValue::asString).collect(Collectors.toSet());
    }

    @Override
    public void setLongTaskEnabled(boolean enabled) {
        this.getElement().setProperty("traceLongTask", enabled);
    }

    @Override
    public boolean isLongTaskEnabled() {
        return this.getElement().getProperty("traceLongTask", false);
    }

    @Override
    public void setXMLHttpRequestEnabled(boolean enabled) {
        this.getElement().setProperty("traceXmlHTTPRequest", enabled);
    }

    @Override
    public boolean isXMLHttpRequestEnabled() {
        return this.getElement().getProperty("traceXmlHTTPRequest", false);
    }

    @Override
    public void setIgnoreVaadinURLs(boolean ignore) {
        this.getElement().setProperty("ignoreVaadinURLs", ignore);
    }

    @Override
    public boolean isIgnoreVaadinURLs() {
        return this.getElement().getProperty("ignoreVaadinURLs", false);
    }

    @Override
    public void setIgnoredURLs(Collection<ObservabilityClientConfiguration.URLPattern> urls) {
        this.getElement().setPropertyList("ignoredURLs", urls.stream().map(ObservabilityClientConfiguration.URLPattern::toInternalFormat).collect(Collectors.toList()));
    }

    @Override
    public List<ObservabilityClientConfiguration.URLPattern> getIgnoredURLs() {
        if (this.getElement().hasProperty("ignoredURLs")) {
            return JsonUtils.stream((JsonArray)((JsonArray)this.getElement().getPropertyRaw("ignoredURLs"))).map(JsonValue::asString).map(ObservabilityClientConfiguration.URLPattern::fromInternalFormat).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void addIgnoredURL(ObservabilityClientConfiguration.URLPattern url) {
        ArrayList<ObservabilityClientConfiguration.URLPattern> ignoredUrls = new ArrayList<ObservabilityClientConfiguration.URLPattern>(this.getIgnoredURLs());
        ignoredUrls.add(url);
        this.setIgnoredURLs(ignoredUrls);
    }

    @Override
    public void setFrontendErrorEnabled(boolean enabled) {
        this.getElement().setProperty("traceErrors", enabled);
    }

    @Override
    public boolean isFrontendErrorEnabled() {
        return this.getElement().getProperty("traceErrors", false);
    }
}

