/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.observability;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservabilityHandler
extends SynchronizedRequestHandler {
    private static final String PATH = "/";
    private static final String ID_PARAMETER = "id";
    private static final String REQUEST_TYPE = "o11y";
    private static final String HTTP_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/json";
    private final String id = UUID.randomUUID().toString();
    transient Function<String, String> config = key -> {
        ObservabilityHandler.getLogger().error("Observability agent is not running");
        return null;
    };
    transient BiConsumer<String, Map<String, Object>> exporter = (id, map) -> ObservabilityHandler.getLogger().error("Observability agent is not running");

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ObservabilityHandler.class);
    }

    static ObservabilityHandler ensureInstalled(UI ui) {
        ObservabilityHandler observabilityHandler = (ObservabilityHandler)((Object)ComponentUtil.getData((Component)ui, ObservabilityHandler.class));
        if (observabilityHandler != null) {
            return observabilityHandler;
        }
        ObservabilityHandler newObservabilityHandler = new ObservabilityHandler();
        VaadinSession session = ui.getSession();
        session.addRequestHandler((RequestHandler)newObservabilityHandler);
        ComponentUtil.setData((Component)ui, ObservabilityHandler.class, (Object)((Object)newObservabilityHandler));
        ui.addAttachListener((ComponentEventListener & Serializable)attachEvent -> {
            UI attachUI = attachEvent.getUI();
            VaadinSession attachSession = attachEvent.getSession();
            if (ComponentUtil.getData((Component)attachUI, ObservabilityHandler.class) == null) {
                attachSession.addRequestHandler((RequestHandler)newObservabilityHandler);
                ComponentUtil.setData((Component)attachUI, ObservabilityHandler.class, (Object)((Object)newObservabilityHandler));
            }
        });
        ui.addDetachListener((ComponentEventListener & Serializable)detachEvent -> {
            UI detachUI = detachEvent.getUI();
            VaadinSession detachSession = detachEvent.getSession();
            if (ComponentUtil.getData((Component)detachUI, ObservabilityHandler.class) != null) {
                detachSession.removeRequestHandler((RequestHandler)newObservabilityHandler);
                ComponentUtil.setData((Component)detachUI, ObservabilityHandler.class, null);
            }
        });
        return newObservabilityHandler;
    }

    protected boolean canHandleRequest(VaadinRequest request) {
        if (!PATH.equals(request.getPathInfo())) {
            return false;
        }
        String requestType = request.getParameter("v-r");
        String instanceId = request.getParameter(ID_PARAMETER);
        return REQUEST_TYPE.equals(requestType) && this.id.equals(instanceId);
    }

    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) {
        if (!HTTP_METHOD.equals(request.getMethod())) {
            response.setStatus(405);
            return true;
        }
        if (!CONTENT_TYPE.equals(request.getContentType())) {
            response.setStatus(415);
            return true;
        }
        try {
            Map objectMap = (Map)new ObjectMapper().readerForMapOf(Object.class).readValue(request.getInputStream());
            if (!objectMap.containsKey("resourceSpans")) {
                ObservabilityHandler.getLogger().error("Malformed traces message.");
                response.setStatus(400);
                return true;
            }
            this.exporter.accept(this.id, objectMap);
            response.setStatus(200);
        }
        catch (IOException e) {
            response.setStatus(400);
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public String getConfigProperty(String key) {
        return this.config.apply(key);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.config = key -> {
            ObservabilityHandler.getLogger().error("Observability agent is not running");
            return null;
        };
        this.exporter = (id, map) -> ObservabilityHandler.getLogger().error("Observability agent is not running");
    }
}

