/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.observability;

import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.exception.EndpointException;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

@Endpoint
@AnonymousAllowed
public class ObservabilityEndpoint {
    private static BiConsumer<String, Map<String, Object>> exporter = (id, map) -> ObservabilityEndpoint.getLogger().error("Observability agent is not running");

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ObservabilityEndpoint.class);
    }

    public void export(String jsonString) {
        try {
            Map objectMap = (Map)new ObjectMapper().readerForMapOf(Object.class).readValue(jsonString);
            if (!objectMap.containsKey("resourceSpans")) {
                ObservabilityEndpoint.getLogger().error("Malformed traces message.");
                throw new EndpointException("Malformed traces message.");
            }
            exporter.accept(null, objectMap);
        }
        catch (JacksonException e) {
            ObservabilityEndpoint.getLogger().error("Malformed JSON.", (Throwable)e);
            throw new EndpointException("Malformed JSON.", (Throwable)e);
        }
    }
}

