/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class ExceptionLogger {
    private static final PatchLogger logger = PatchLogger.getLogger(ExceptionLogger.class.getName());
    private static final AtomicInteger counter = new AtomicInteger();

    public static void logSuppressedError(String message, Throwable error) {
        logger.log(Level.FINE, message, error);
        counter.incrementAndGet();
    }

    public static int getAndReset() {
        return counter.getAndSet(0);
    }

    private ExceptionLogger() {
    }
}

