/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class HttpSpanNameExtractorBuilder<REQUEST> {
    @Nullable
    final HttpClientAttributesGetter<REQUEST, ?> clientGetter;
    @Nullable
    final HttpServerAttributesGetter<REQUEST, ?> serverGetter;
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;

    public HttpSpanNameExtractorBuilder(@Nullable HttpClientAttributesGetter<REQUEST, ?> clientGetter, @Nullable HttpServerAttributesGetter<REQUEST, ?> serverGetter) {
        this.clientGetter = clientGetter;
        this.serverGetter = serverGetter;
    }

    @CanIgnoreReturnValue
    public HttpSpanNameExtractorBuilder<REQUEST> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    public SpanNameExtractor<REQUEST> build() {
        HashSet<String> knownMethods = new HashSet<String>(this.knownMethods);
        return this.clientGetter != null ? new HttpSpanNameExtractor.Client<REQUEST>(this.clientGetter, knownMethods) : new HttpSpanNameExtractor.Server<REQUEST>(Objects.requireNonNull(this.serverGetter), knownMethods);
    }
}

