/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.propagation;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.TemporaryBuffers;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextPropagator
implements TextMapPropagator {
    private static final PatchLogger logger = PatchLogger.getLogger(W3CTraceContextPropagator.class.getName());
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "00";
    private static final W3CTraceContextPropagator INSTANCE;

    private W3CTraceContextPropagator() {
    }

    public static W3CTraceContextPropagator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] chars = TemporaryBuffers.chars(TRACEPARENT_HEADER_SIZE);
        chars[0] = "00".charAt(0);
        chars[1] = "00".charAt(1);
        chars[2] = 45;
        String traceId = spanContext.getTraceId();
        traceId.getChars(0, traceId.length(), chars, 3);
        chars[W3CTraceContextPropagator.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanId();
        spanId.getChars(0, spanId.length(), chars, SPAN_ID_OFFSET);
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET - 1] = 45;
        String traceFlagsHex = spanContext.getTraceFlags().asHex();
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
        chars[W3CTraceContextPropagator.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
        setter.set(carrier, TRACE_PARENT, new String(chars, 0, TRACEPARENT_HEADER_SIZE));
        TraceState traceState = spanContext.getTraceState();
        if (traceState.isEmpty()) {
            return;
        }
        setter.set(carrier, TRACE_STATE, W3CTraceContextEncoding.encodeTraceState(traceState));
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        SpanContext spanContext = W3CTraceContextPropagator.extractImpl(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with(Span.wrap(spanContext));
    }

    private static <C> SpanContext extractImpl(@Nullable C carrier, TextMapGetter<C> getter) {
        String traceParent = getter.get(carrier, TRACE_PARENT);
        if (traceParent == null) {
            return SpanContext.getInvalid();
        }
        SpanContext contextFromParentHeader = W3CTraceContextPropagator.extractContextFromTraceParent(traceParent);
        if (!contextFromParentHeader.isValid()) {
            return contextFromParentHeader;
        }
        String traceStateHeader = getter.get(carrier, TRACE_STATE);
        if (traceStateHeader == null || traceStateHeader.isEmpty()) {
            return contextFromParentHeader;
        }
        try {
            TraceState traceState = W3CTraceContextEncoding.decodeTraceState(traceStateHeader);
            return SpanContext.createFromRemoteParent(contextFromParentHeader.getTraceId(), contextFromParentHeader.getSpanId(), contextFromParentHeader.getTraceFlags(), traceState);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Unparseable tracestate header. Returning span context without state.");
            return contextFromParentHeader;
        }
    }

    private static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String version = traceparent.substring(0, 2);
        if (!VALID_VERSIONS.contains(version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals("00") && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char firstTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET);
        char secondTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET + 1);
        if (!OtelEncodingUtils.isValidBase16Character(firstTraceFlagsChar) || !OtelEncodingUtils.isValidBase16Character(secondTraceFlagsChar)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(firstTraceFlagsChar, secondTraceFlagsChar));
        return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, TraceState.getDefault());
    }

    public String toString() {
        return "W3CTraceContextPropagator";
    }

    static {
        INSTANCE = new W3CTraceContextPropagator();
        VALID_VERSIONS = new HashSet<String>();
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

