/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class InstrumenterUtil {
    private static final PatchLogger logger = PatchLogger.getLogger(InstrumenterUtil.class.getName());
    private static final Method startAndEndMethod;

    public static <REQUEST, RESPONSE> Context startAndEnd(Instrumenter<REQUEST, RESPONSE> instrumenter, Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, Instant startTime, Instant endTime) {
        if (startAndEndMethod == null) {
            return parentContext;
        }
        try {
            return (Context)startAndEndMethod.invoke(instrumenter, parentContext, request, response, error, startTime, endTime);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.log(Level.WARNING, "Error occurred when calling Instrumenter#startAndEnd()", e);
            return parentContext;
        }
    }

    private InstrumenterUtil() {
    }

    static {
        Method method = null;
        try {
            method = Instrumenter.class.getDeclaredMethod("startAndEnd", Context.class, Object.class, Object.class, Throwable.class, Instant.class, Instant.class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Could not get Instrumenter#startAndEnd() method with reflection", e);
        }
        startAndEndMethod = method;
    }
}

