/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support;

import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBinding;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.ParameterizedClass;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

class AttributeBindingFactory {
    private AttributeBindingFactory() {
    }

    static AttributeBinding createBinding(String name, Type type) {
        if (type == String.class) {
            AttributeKey<String> key = AttributeKey.stringKey(name);
            return (setter, arg) -> setter.put(key, (String)arg);
        }
        if (type == Long.TYPE || type == Long.class) {
            AttributeKey<Long> key = AttributeKey.longKey(name);
            return (setter, arg) -> setter.put(key, (Long)arg);
        }
        if (type == Double.TYPE || type == Double.class) {
            AttributeKey<Double> key = AttributeKey.doubleKey(name);
            return (setter, arg) -> setter.put(key, (Double)arg);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            AttributeKey<Boolean> key = AttributeKey.booleanKey(name);
            return (setter, arg) -> setter.put(key, (Boolean)arg);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            AttributeKey<Long> key = AttributeKey.longKey(name);
            return (setter, arg) -> setter.put(key, Long.valueOf(((Integer)arg).longValue()));
        }
        if (type == Float.TYPE || type == Float.class) {
            AttributeKey<Double> key = AttributeKey.doubleKey(name);
            return (setter, arg) -> setter.put(key, Double.valueOf(((Float)arg).doubleValue()));
        }
        if (AttributeBindingFactory.isArrayType(type)) {
            return AttributeBindingFactory.arrayBinding(name, type);
        }
        return AttributeBindingFactory.resolveListComponentType(type).map(componentType -> AttributeBindingFactory.listBinding(name, componentType)).orElseGet(() -> AttributeBindingFactory.defaultBinding(name));
    }

    private static boolean isArrayType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return false;
    }

    private static Optional<Type> resolveListComponentType(Type type) {
        return ParameterizedClass.of(type).findParameterizedSuperclass(List.class).map(pc -> pc.getActualTypeArguments()[0]);
    }

    private static AttributeBinding arrayBinding(String name, Type type) {
        if (type == String[].class) {
            AttributeKey<List<String>> key = AttributeKey.stringArrayKey(name);
            return (setter, arg) -> setter.put(key, Arrays.asList((String[])arg));
        }
        if (type == Long[].class) {
            AttributeKey<List<Long>> key = AttributeKey.longArrayKey(name);
            return (setter, arg) -> setter.put(key, Arrays.asList((Long[])arg));
        }
        if (type == Double[].class) {
            AttributeKey<List<Double>> key = AttributeKey.doubleArrayKey(name);
            return (setter, arg) -> setter.put(key, Arrays.asList((Double[])arg));
        }
        if (type == Boolean[].class) {
            AttributeKey<List<Boolean>> key = AttributeKey.booleanArrayKey(name);
            return (setter, arg) -> setter.put(key, Arrays.asList((Boolean[])arg));
        }
        if (type == long[].class) {
            return AttributeBindingFactory.longArrayBinding(name);
        }
        if (type == int[].class) {
            return AttributeBindingFactory.intArrayBinding(name);
        }
        if (type == float[].class) {
            return AttributeBindingFactory.floatArrayBinding(name);
        }
        if (type == double[].class) {
            return AttributeBindingFactory.doubleArrayBinding(name);
        }
        if (type == boolean[].class) {
            return AttributeBindingFactory.booleanArrayBinding(name);
        }
        if (type == Integer[].class) {
            return AttributeBindingFactory.boxedIntegerArrayBinding(name);
        }
        if (type == Float[].class) {
            return AttributeBindingFactory.boxedFloatArrayBinding(name);
        }
        return AttributeBindingFactory.defaultArrayBinding(name);
    }

    private static AttributeBinding listBinding(String name, Type componentType) {
        if (componentType == String.class) {
            AttributeKey<List<String>> key = AttributeKey.stringArrayKey(name);
            return (setter, arg) -> setter.put(key, (List)arg);
        }
        if (componentType == Long.class) {
            AttributeKey<List<Long>> key = AttributeKey.longArrayKey(name);
            return (setter, arg) -> setter.put(key, (List)arg);
        }
        if (componentType == Double.class) {
            AttributeKey<List<Double>> key = AttributeKey.doubleArrayKey(name);
            return (setter, arg) -> setter.put(key, (List)arg);
        }
        if (componentType == Boolean.class) {
            AttributeKey<List<Boolean>> key = AttributeKey.booleanArrayKey(name);
            return (setter, arg) -> setter.put(key, (List)arg);
        }
        if (componentType == Integer.class) {
            AttributeKey key = AttributeKey.longArrayKey(name);
            return AttributeBindingFactory.mappedListBinding(key, Integer::longValue);
        }
        if (componentType == Float.class) {
            AttributeKey key = AttributeKey.doubleArrayKey(name);
            return AttributeBindingFactory.mappedListBinding(key, Float::doubleValue);
        }
        return AttributeBindingFactory.defaultListBinding(name);
    }

    private static AttributeBinding intArrayBinding(String name) {
        AttributeKey<List<Long>> key = AttributeKey.longArrayKey(name);
        return (setter, arg) -> {
            final int[] array = (int[])arg;
            AbstractList<Long> wrapper = new AbstractList<Long>(){

                @Override
                public Long get(int index) {
                    return array[index];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding boxedIntegerArrayBinding(String name) {
        AttributeKey<List<Long>> key = AttributeKey.longArrayKey(name);
        return (setter, arg) -> {
            final Integer[] array = (Integer[])arg;
            AbstractList<Long> wrapper = new AbstractList<Long>(){

                @Override
                public Long get(int index) {
                    Integer value = array[index];
                    return value != null ? Long.valueOf(value.longValue()) : null;
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding longArrayBinding(String name) {
        AttributeKey<List<Long>> key = AttributeKey.longArrayKey(name);
        return (setter, arg) -> {
            final long[] array = (long[])arg;
            AbstractList<Long> wrapper = new AbstractList<Long>(){

                @Override
                public Long get(int index) {
                    return array[index];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding floatArrayBinding(String name) {
        AttributeKey<List<Double>> key = AttributeKey.doubleArrayKey(name);
        return (setter, arg) -> {
            final float[] array = (float[])arg;
            AbstractList<Double> wrapper = new AbstractList<Double>(){

                @Override
                public Double get(int index) {
                    return array[index];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding boxedFloatArrayBinding(String name) {
        AttributeKey<List<Double>> key = AttributeKey.doubleArrayKey(name);
        return (setter, arg) -> {
            final Float[] array = (Float[])arg;
            AbstractList<Double> wrapper = new AbstractList<Double>(){

                @Override
                public Double get(int index) {
                    Float value = array[index];
                    return value != null ? Double.valueOf(value.doubleValue()) : null;
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding doubleArrayBinding(String name) {
        AttributeKey<List<Double>> key = AttributeKey.doubleArrayKey(name);
        return (setter, arg) -> {
            final double[] array = (double[])arg;
            AbstractList<Double> wrapper = new AbstractList<Double>(){

                @Override
                public Double get(int index) {
                    return array[index];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding booleanArrayBinding(String name) {
        AttributeKey<List<Boolean>> key = AttributeKey.booleanArrayKey(name);
        return (setter, arg) -> {
            final boolean[] array = (boolean[])arg;
            AbstractList<Boolean> wrapper = new AbstractList<Boolean>(){

                @Override
                public Boolean get(int index) {
                    return array[index];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding defaultArrayBinding(String name) {
        AttributeKey<List<String>> key = AttributeKey.stringArrayKey(name);
        return (setter, arg) -> {
            final Object[] array = (Object[])arg;
            AbstractList<String> wrapper = new AbstractList<String>(){

                @Override
                public String get(int index) {
                    Object value = array[index];
                    return value != null ? value.toString() : null;
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static <T, U> AttributeBinding mappedListBinding(AttributeKey<List<U>> key, final Function<T, U> mapping) {
        return (setter, arg) -> {
            final List list = (List)arg;
            AbstractList wrapper = new AbstractList<U>(){

                @Override
                public U get(int index) {
                    Object value = list.get(index);
                    return value != null ? (Object)mapping.apply(value) : null;
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
            setter.put(key, wrapper);
        };
    }

    private static AttributeBinding defaultListBinding(String name) {
        AttributeKey key = AttributeKey.stringArrayKey(name);
        return AttributeBindingFactory.mappedListBinding(key, Object::toString);
    }

    private static AttributeBinding defaultBinding(String name) {
        AttributeKey<String> key = AttributeKey.stringKey(name);
        return (setter, arg) -> setter.put(key, arg.toString());
    }
}

