/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.HashSet;
import java.util.Set;

final class TemporaryMetricsView {
    private static final Set<AttributeKey> durationAlwaysInclude = TemporaryMetricsView.buildDurationAlwaysInclude();
    private static final Set<AttributeKey> durationClientView = TemporaryMetricsView.buildDurationClientView();
    private static final Set<AttributeKey> durationServerView = TemporaryMetricsView.buildDurationServerView();
    private static final Set<AttributeKey> activeRequestsView = TemporaryMetricsView.buildActiveRequestsView();

    private static Set<AttributeKey> buildDurationAlwaysInclude() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>();
        view.add(SemanticAttributes.HTTP_METHOD);
        view.add(SemanticAttributes.HTTP_STATUS_CODE);
        view.add(SemanticAttributes.HTTP_FLAVOR);
        return view;
    }

    private static Set<AttributeKey> buildDurationClientView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(durationAlwaysInclude);
        view.add(SemanticAttributes.NET_PEER_NAME);
        view.add(SemanticAttributes.NET_PEER_PORT);
        view.add(SemanticAttributes.NET_SOCK_PEER_ADDR);
        return view;
    }

    private static Set<AttributeKey> buildDurationServerView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(durationAlwaysInclude);
        view.add(SemanticAttributes.HTTP_SCHEME);
        view.add(SemanticAttributes.NET_HOST_NAME);
        view.add(SemanticAttributes.NET_HOST_PORT);
        view.add(SemanticAttributes.HTTP_ROUTE);
        return view;
    }

    private static Set<AttributeKey> buildActiveRequestsView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>();
        view.add(SemanticAttributes.HTTP_METHOD);
        view.add(SemanticAttributes.HTTP_SCHEME);
        view.add(SemanticAttributes.HTTP_FLAVOR);
        view.add(SemanticAttributes.NET_HOST_NAME);
        view.add(SemanticAttributes.NET_HOST_PORT);
        return view;
    }

    static Attributes applyClientDurationAndSizeView(Attributes startAttributes, Attributes endAttributes) {
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, startAttributes, durationClientView);
        TemporaryMetricsView.applyView(filtered, endAttributes, durationClientView);
        return filtered.build();
    }

    static Attributes applyServerDurationAndSizeView(Attributes startAttributes, Attributes endAttributes) {
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, startAttributes, durationServerView);
        TemporaryMetricsView.applyView(filtered, endAttributes, durationServerView);
        return filtered.build();
    }

    static Attributes applyActiveRequestsView(Attributes attributes) {
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, attributes, activeRequestsView);
        return filtered.build();
    }

    private static void applyView(AttributesBuilder filtered, Attributes attributes, Set<AttributeKey> view) {
        attributes.forEach((key, value) -> {
            if (view.contains(key)) {
                filtered.put(key, value);
            }
        });
    }

    private TemporaryMetricsView() {
    }
}

