/**
 * Copyright (C) 2022 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.mpr.client;

import java.util.HashMap;

import com.vaadin.mpr.MprUIContent;
import com.vaadin.mpr.core.client.AbstractMprUIContentConnector;
import com.vaadin.mpr.core.client.ComponentSettings;
import com.vaadin.shared.Connector;
import com.vaadin.shared.ui.Connect;

@Connect(MprUIContent.class)
public class MprUIContentConnector extends AbstractMprUIContentConnector {

    @Override
    public MprUIContentState getState() {
        return (MprUIContentState) super.getState();
    }

    @Override
    protected HashMap<Connector, ComponentSettings> getComponentSettings() {
        return getState().componentSettings;
    }
}
