/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.dau;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class TrackedUser {
    private final String trackingHash;
    private final Instant creationTime;
    private final Set<String> userIdentityHashes = new HashSet<String>();

    TrackedUser(String trackingHash) {
        this(trackingHash, Instant.now());
    }

    TrackedUser(String trackingHash, Instant creationTime) {
        this.trackingHash = Objects.requireNonNull(trackingHash, "trackingHash must not be null");
        this.creationTime = creationTime != null ? creationTime.truncatedTo(ChronoUnit.SECONDS) : Instant.now().truncatedTo(ChronoUnit.SECONDS);
    }

    public String getTrackingHash() {
        return this.trackingHash;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Set<String> getUserIdentityHashes() {
        return Collections.unmodifiableSet(this.userIdentityHashes);
    }

    boolean linkUserIdentity(String userIdentityHash) {
        if (userIdentityHash != null && !userIdentityHash.trim().isEmpty()) {
            return this.userIdentityHashes.add(userIdentityHash);
        }
        return false;
    }

    boolean hasLinkedIdentities() {
        return !this.userIdentityHashes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackedUser that = (TrackedUser)o;
        return this.trackingHash.equals(that.trackingHash) && this.creationTime.equals(that.creationTime) && this.userIdentityHashes.equals(that.userIdentityHashes);
    }

    public int hashCode() {
        int result = this.trackingHash.hashCode();
        result = 31 * result + this.creationTime.hashCode();
        result = 31 * result + this.userIdentityHashes.hashCode();
        return result;
    }

    public String toString() {
        return "TrackedUser{trackingHash='" + this.trackingHash + '\'' + ", creationTime=" + this.creationTime + (!this.userIdentityHashes.isEmpty() ? ", userIdentityHashes=[" + String.join((CharSequence)",", this.userIdentityHashes) + ']' : "") + '}';
    }
}

