/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.EnvironmentVariables;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.OfflineKeySource;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class LocalOfflineKey {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OfflineKey read(File offlineKeyLocation) throws IOException {
        if (!offlineKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(offlineKeyLocation);){
            OfflineKey key = new OfflineKey(Util.toString(is), OfflineKeySource.FILE, offlineKeyLocation.getAbsolutePath());
            String fileName = offlineKeyLocation.getName();
            String machineId = key.getMachineId();
            if (machineId != null) {
                if (fileName.equals("offlineKeyV2") || fileName.equals("offlineKeyV2.txt")) {
                    if (!machineId.startsWith("mid2-")) {
                        LocalOfflineKey.getLogger().error("Invalid machine ID format in {}: expected 'mid2-*' but got '{}'", (Object)fileName, (Object)machineId);
                        OfflineKey offlineKey = null;
                        return offlineKey;
                    }
                } else if ((fileName.equals("offlineKey") || fileName.equals("offlineKey.txt")) && !machineId.startsWith("mid-") && !machineId.equals("aa1122")) {
                    LocalOfflineKey.getLogger().error("Invalid machine ID format in {}: expected 'mid-*' but got '{}'", (Object)fileName, (Object)machineId);
                    OfflineKey offlineKey = null;
                    return offlineKey;
                }
            }
            OfflineKey offlineKey = key;
            return offlineKey;
        }
        catch (ParseException e) {
            LocalOfflineKey.getLogger().error("Unable to read offline license from file", (Throwable)e);
            return null;
        }
    }

    public static File[] getLocations() {
        return (File[])Stream.of("offlineKeyV2", "offlineKeyV2.txt", "offlineKey", "offlineKey.txt", "serverKey", "serverKey.txt").map(name -> new File(LocalProKey.getVaadinFolder(), (String)name)).toArray(File[]::new);
    }

    public static OfflineKey get() {
        List<OfflineKey> allKeys = LocalOfflineKey.getAll();
        if (allKeys.isEmpty()) {
            return null;
        }
        OfflineKey first = allKeys.get(0);
        if (first.getSource() != null) {
            switch (first.getSource()) {
                case SYSTEM_PROPERTY: {
                    LocalOfflineKey.getLogger().debug("Using offlineKey from system property");
                    break;
                }
                case ENVIRONMENT_VARIABLE: {
                    LocalOfflineKey.getLogger().debug("Using offlineKey from environment variable");
                    break;
                }
                case FILE: {
                    LocalOfflineKey.getLogger().debug("Found offline key in {}", (Object)first.getSourceDetail());
                }
            }
        }
        return first;
    }

    public static List<OfflineKey> getAll() {
        OfflineKey environmentVariableKey;
        ArrayList<OfflineKey> keys = new ArrayList<OfflineKey>();
        OfflineKey systemPropertyKey = LocalOfflineKey.getSystemProperty();
        if (systemPropertyKey != null) {
            keys.add(systemPropertyKey);
        }
        if ((environmentVariableKey = LocalOfflineKey.getEnvironmentVariable()) != null) {
            keys.add(environmentVariableKey);
        }
        try {
            for (File location : LocalOfflineKey.getLocations()) {
                OfflineKey key = LocalOfflineKey.read(location);
                if (key == null) continue;
                keys.add(key);
            }
        }
        catch (IOException e) {
            LocalOfflineKey.getLogger().debug("Unable to read offline keys", (Throwable)e);
        }
        return keys;
    }

    public static Optional<OfflineKey> fromString(String key) {
        if (key != null) {
            return Optional.ofNullable(LocalOfflineKey.parseOfflineKey(key, null));
        }
        return Optional.empty();
    }

    private static OfflineKey getSystemProperty() {
        String jwtData = System.getProperty("vaadin.offlineKey");
        if (jwtData == null && (jwtData = System.getProperty("vaadin.key")) == null) {
            return null;
        }
        return LocalOfflineKey.parseOfflineKey(jwtData, OfflineKeySource.SYSTEM_PROPERTY);
    }

    private static OfflineKey getEnvironmentVariable() {
        String value = EnvironmentVariables.get("VAADIN_OFFLINE_KEY");
        if (value == null && (value = EnvironmentVariables.get("VAADIN_KEY")) == null) {
            return null;
        }
        return LocalOfflineKey.parseOfflineKey(value, OfflineKeySource.ENVIRONMENT_VARIABLE);
    }

    private static OfflineKey parseOfflineKey(String jwtData, OfflineKeySource source) {
        try {
            return new OfflineKey(jwtData, source, null);
        }
        catch (ParseException e) {
            if (source != null) {
                LocalOfflineKey.getLogger().error("Unable to read offline license from {}", (Object)source, (Object)e);
            }
            return null;
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

