/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonArray;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonBoolean;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonException;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonFactory;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNull;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNumber;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonObject;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonString;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;

/**
 * Implementation of LicenseCheckerJsonFactory interface using org.json library.
 */
public class LicenseCheckerJreJsonFactory implements LicenseCheckerJsonFactory {

    public LicenseCheckerJsonString create(String string) {
        assert string != null;
        return new LicenseCheckerJreJsonString(string);
    }

    public LicenseCheckerJsonNumber create(double number) {
        return new LicenseCheckerJreJsonNumber(number);
    }

    public LicenseCheckerJsonBoolean create(boolean bool) {
        return new LicenseCheckerJreJsonBoolean(bool);
    }

    public LicenseCheckerJsonArray createArray() {
        return new LicenseCheckerJreJsonArray(this);
    }

    public LicenseCheckerJsonNull createNull() {
        return LicenseCheckerJreJsonNull.NULL_INSTANCE;
    }

    public LicenseCheckerJsonObject createObject() {
        return new LicenseCheckerJreJsonObject(this);
    }

    public <T extends LicenseCheckerJsonValue> T parse(String jsonString)
            throws LicenseCheckerJsonException {
        if (jsonString.startsWith("(") && jsonString.endsWith(")")) {
            // some clients send in (json) expecting an eval is required
            jsonString = jsonString.substring(1, jsonString.length() - 1);
        }
        return new LicenseCheckerJsonTokenizer(this, jsonString).nextValue();
    }
}
