/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.json.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonBoolean;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;

/**
 * Server-side implementation of LicenseCheckerJsonBoolean.
 */
public class LicenseCheckerJreJsonBoolean extends LicenseCheckerJreJsonValue
        implements LicenseCheckerJsonBoolean {

    private static final long serialVersionUID = 1L;

    private transient boolean bool;

    public LicenseCheckerJreJsonBoolean(boolean bool) {
        this.bool = bool;
    }

    @Override
    public boolean asBoolean() {
        return getBoolean();
    }

    @Override
    public double asNumber() {
        return getBoolean() ? 1 : 0;
    }

    @Override
    public String asString() {
        return Boolean.toString(getBoolean());
    }

    public boolean getBoolean() {
        return bool;
    }

    public Object getObject() {
        return getBoolean();
    }

    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.BOOLEAN;
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return getObject()
                .equals(((LicenseCheckerJreJsonValue) value).getObject());
    }

    @Override
    public void traverse(
            com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor visitor,
            LicenseCheckerJsonContext ctx) {
        visitor.visit(getBoolean(), ctx);
    }

    public String toJson() throws IllegalStateException {
        return String.valueOf(bool);
    }

    private void readObject(ObjectInputStream stream)
            throws IOException, ClassNotFoundException {
        LicenseCheckerJreJsonBoolean instance = parseJson(stream);
        this.bool = instance.bool;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(toJson());
    }

}
