/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.json;

/**
 * Factory interface for parsing and creating JSON objects.
 */
public interface LicenseCheckerJsonFactory {

    /**
     * Create a LicenseCheckerJsonString from a Java String.
     *
     * @param string
     *            a Java String
     * @return the parsed LicenseCheckerJsonString
     */
    LicenseCheckerJsonString create(String string);

    /**
     * Create a LicenseCheckerJsonNumber from a Java double.
     *
     * @param number
     *            a Java double
     * @return the parsed LicenseCheckerJsonNumber
     */
    LicenseCheckerJsonNumber create(double number);

    /**
     * Create a LicenseCheckerJsonBoolean from a Java boolean.
     *
     * @param bool
     *            a Java boolean
     * @return the parsed LicenseCheckerJsonBoolean
     */
    LicenseCheckerJsonBoolean create(boolean bool);

    /**
     * Create an empty LicenseCheckerJsonArray.
     *
     * @return a new LicenseCheckerJsonArray
     */
    com.vaadin.pro.licensechecker.json.LicenseCheckerJsonArray createArray();

    /**
     * Create a LicenseCheckerJsonNull.
     *
     * @return a LicenseCheckerJsonNull instance
     */
    LicenseCheckerJsonNull createNull();

    /**
     * Create an empty LicenseCheckerJsonObject.
     *
     * @return a new LicenseCheckerJsonObject
     */
    LicenseCheckerJsonObject createObject();

    /**
     * Parse a String in JSON format and return a LicenseCheckerJsonValue of the
     * appropriate type.
     *
     * @param jsonString
     *            a String in JSON format
     * @return a parsed LicenseCheckerJsonValue
     */
    <T extends LicenseCheckerJsonValue> T parse(String jsonString)
            throws com.vaadin.pro.licensechecker.json.LicenseCheckerJsonException;
}
