/*
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker;

/**
 * Represents an exception that occurs during the check of pre-trial status.
 */
public class PreTrialStatusCheckException extends RuntimeException {

    private final boolean cannotReachServer;

    /**
     * Constructs a new {@link PreTrialStatusCheckException} with the specified
     * detail message.
     *
     * @param message
     *            the detail message, which provides more information about the
     *            exception.
     */
    public PreTrialStatusCheckException(String message) {
        super(message);
        cannotReachServer = false;
    }

    /**
     * Constructs a new {@link PreTrialStatusCheckException} with the specified
     * detail message.
     *
     * @param message
     *            the detail message, which provides more information about the
     *            exception.
     * @param cannotReachServer
     *            indicates whether the exception was caused by an inability to
     *            reach the server.
     */
    public PreTrialStatusCheckException(String message,
            boolean cannotReachServer) {
        super(message);
        this.cannotReachServer = cannotReachServer;
    }

    /**
     * Indicates whether the exception was caused by an inability to reach the
     * server.
     *
     * @return true if the server could not be reached, false otherwise.
     */
    public boolean isCannotReachServer() {
        return cannotReachServer;
    }
}
