/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.json;

import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJreJsonFactory;

/**
 * Vends out implementation of LicenseCheckerJsonFactory.
 */
public class LicenseCheckerJson {

    public static LicenseCheckerJsonString create(String string) {
        return instance().create(string);
    }

    public static LicenseCheckerJsonBoolean create(boolean bool) {
        return instance().create(bool);
    }

    public static LicenseCheckerJsonArray createArray() {
        return instance().createArray();
    }

    public static LicenseCheckerJsonNull createNull() {
        return instance().createNull();
    }

    public static LicenseCheckerJsonNumber create(double number) {
        return instance().create(number);
    }

    public static LicenseCheckerJsonObject createObject() {
        return instance().createObject();
    }

    public static LicenseCheckerJsonFactory instance() {
        return new LicenseCheckerJreJsonFactory();
    }

    public static LicenseCheckerJsonObject parse(String jsonString) {
        return instance().parse(jsonString);
    }
}
