/*
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker;

/**
 * Represents an exception that occurs during the creation of a pre-trial
 * period.
 */
public class PreTrialCreationException extends RuntimeException {

    /**
     * Constructs a new {@link PreTrialCreationException} with the specified
     * detail message.
     *
     * @param message
     *            the detail message, which provides more information about the
     *            exception.
     */
    public PreTrialCreationException(String message) {
        super(message);
    }

    /**
     * Represents an exception thrown when the creation of a pre-trial period
     * fails due to the current trial being expired and not yet renewable.
     */
    public static class Expired extends PreTrialCreationException {

        /**
         * Constructs a new {@code Expired} exception with the specified detail
         * message.
         *
         * @param message
         *            the detail message providing more information about the
         *            reason for the exception.
         */
        public Expired(String message) {
            super(message);
        }
    }
}
